/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.apihub.sdkclient.util;

import com.dtyunxi.huieryun.apihub.sdkclient.base.SdkReqMethod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class HttpUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:\"|')?([^\\s,;\"']*)");

    public static String request(String httpUrl, SdkReqMethod requestMethod, Map<String, String> httpHeaders, Map<String, String> paramValueMap) throws IOException {
        httpHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        String body = HttpUtil.getParamStr(paramValueMap);
        return HttpUtil.fetch(requestMethod.getMethod(), httpUrl, body, httpHeaders);
    }

    private static String fetch(String method, String url, String body, Map<String, String> headers) throws IOException {
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        if (method != null) {
            conn.setRequestMethod(method);
        }
        if (headers != null) {
            for (String key : headers.keySet()) {
                conn.addRequestProperty(key, headers.get(key));
            }
        }
        if (body != null) {
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(body.getBytes());
            os.flush();
            os.close();
        }
        boolean isGzip = false;
        String charset = null;
        if (conn.getResponseCode() == 200) {
            String contentEncoding = conn.getHeaderField("Content-Encoding");
            if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                isGzip = true;
            }
            String contentType = conn.getHeaderField("Content-Type");
            charset = HttpUtil.getCharsetFromContentType(contentType);
        }
        InputStream is = conn.getInputStream();
        String response = HttpUtil.streamToString(is, charset, isGzip);
        is.close();
        if (conn.getResponseCode() == 301) {
            String location = conn.getHeaderField("Location");
            return HttpUtil.fetch(method, location, body, headers);
        }
        return response;
    }

    private static String getParamStr(Map<String, String> paramValueMap) throws UnsupportedEncodingException {
        String body = "";
        if (paramValueMap != null) {
            boolean first = true;
            for (String param : paramValueMap.keySet()) {
                if (first) {
                    first = false;
                } else {
                    body = body + "&";
                }
                String value = paramValueMap.get(param);
                body = body + URLEncoder.encode(param, "UTF-8") + "=";
                body = body + URLEncoder.encode(value, "UTF-8");
            }
        }
        return body;
    }

    private static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            String charset = m.group(1).trim();
            if ((charset = charset.replace("charset=", "")).length() == 0) {
                return null;
            }
            try {
                if ("gb2312".equalsIgnoreCase(charset) || "gbk".equalsIgnoreCase(charset)) {
                    charset = "gb18030";
                }
                if (Charset.isSupported(charset)) {
                    return charset;
                }
                if (Charset.isSupported(charset = charset.toUpperCase(Locale.ENGLISH))) {
                    return charset;
                }
            }
            catch (IllegalCharsetNameException e) {
                return null;
            }
        }
        return null;
    }

    private static String streamToString(InputStream is, String charset, boolean isGzip) throws IOException {
        if (charset == null || "".equals(charset.trim())) {
            charset = "utf-8";
        }
        BufferedReader reader = null;
        reader = isGzip ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(is), charset)) : new BufferedReader(new InputStreamReader(is, charset));
        String line = "";
        StringBuffer result = new StringBuffer();
        while (null != (line = reader.readLine())) {
            if ("".equals(line)) continue;
            result.append(line).append("\r\n");
        }
        return result.toString();
    }
}

