/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.starter.cache.CubeCacheProperties;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import java.time.Duration;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.JedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.LettuceConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;

@EnableConfigurationProperties(value={CubeCacheProperties.class})
@PropertySource(value={"classpath:config/redis.properties"})
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
@Import(value={LettuceConnectionConfiguration.class, JedisConnectionConfiguration.class})
public class CustomRedisAutoConfiguration {
    private final CacheRegistryVo cacheRegistryVo;

    public CustomRedisAutoConfiguration(CacheRegistryVo cacheRegistryVo) {
        this.cacheRegistryVo = cacheRegistryVo;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public RedisProperties redisProperties() {
        RedisProperties redisProperties = new RedisProperties();
        switch (this.cacheRegistryVo.getWorkModelEnum()) {
            case SINGLE: {
                String password;
                String url = this.cacheRegistryVo.getAddresses()[0];
                String redisProtocol = "redis://";
                if (url.startsWith(redisProtocol)) {
                    url = url.replace(redisProtocol, "");
                }
                if (StrUtil.isNotBlank((CharSequence)(password = this.cacheRegistryVo.getAppSecret()))) {
                    url = password + "@" + url;
                }
                redisProperties.setUrl(redisProtocol + url);
                break;
            }
            case CLUSTER: {
                RedisProperties.Cluster cluster = new RedisProperties.Cluster();
                cluster.setNodes(Arrays.asList(this.cacheRegistryVo.getAddresses()));
                redisProperties.setCluster(cluster);
                break;
            }
            case SENTINEL: {
                RedisProperties.Sentinel sentinel = new RedisProperties.Sentinel();
                sentinel.setNodes(Arrays.asList(this.cacheRegistryVo.getAddresses()));
                sentinel.setPassword(this.cacheRegistryVo.getAppSecret());
                redisProperties.setSentinel(sentinel);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)this.cacheRegistryVo.getAppId())) {
            redisProperties.setUsername(this.cacheRegistryVo.getAppId());
        }
        if (StrUtil.isNotBlank((CharSequence)this.cacheRegistryVo.getAppSecret())) {
            redisProperties.setPassword(this.cacheRegistryVo.getAppSecret());
        }
        redisProperties.setDatabase(this.cacheRegistryVo.getDbIndex());
        redisProperties.setSsl(this.cacheRegistryVo.isSsl());
        RedisProperties.Pool pool = new RedisProperties.Pool();
        pool.setMaxActive(this.cacheRegistryVo.getMaxTotal());
        pool.setMaxIdle(this.cacheRegistryVo.getMaxIdle());
        pool.setMinIdle(1);
        pool.setMaxWait(Duration.ofMillis(this.cacheRegistryVo.getMaxWaitMillis()));
        if (StrUtil.isNotBlank((CharSequence)this.cacheRegistryVo.getRedisClientType()) && this.cacheRegistryVo.getRedisClientType().equalsIgnoreCase("JEDIS")) {
            redisProperties.setClientType(RedisProperties.ClientType.JEDIS);
            redisProperties.getJedis().setPool(pool);
        } else {
            redisProperties.setClientType(RedisProperties.ClientType.LETTUCE);
            redisProperties.getLettuce().setPool(pool);
        }
        return redisProperties;
    }
}

