/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Set;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.CustomZSetOperations;
import org.springframework.data.redis.core.DefaultZSetOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

public class CustomZSetOperationsImpl<K, V>
extends DefaultZSetOperations<K, V>
implements CustomZSetOperations<K, V> {
    CustomZSetOperationsImpl(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public Long count(K key, String min, String max) {
        byte[] rawKey = this.rawKey(key);
        return (Long)this.execute(connection -> {
            RedisZSetCommands.Range range = this.getRange(min, max);
            return connection.zCount(rawKey, range);
        }, true);
    }

    @Override
    public Set<V> zrangeByScore(K key, String min, String max) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = (Set)this.execute(connection -> connection.zRangeByScore(rawKey, min, max), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> zrangeByScore(K key, String min, String max, int offset, int count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = (Set)this.execute(connection -> connection.zRangeByScore(rawKey, min, max, (long)offset, (long)count), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K key, String min, String max) {
        byte[] rawKey = this.rawKey(key);
        RedisZSetCommands.Range range = this.getRange(min, max);
        Set rawValues = (Set)this.execute(connection -> connection.zRangeByScoreWithScores(rawKey, range), true);
        return this.deserializeTupleValues(rawValues);
    }

    private RedisZSetCommands.Range getRange(String min, String max) {
        RedisZSetCommands.Range range = RedisZSetCommands.Range.range();
        try {
            range.gte((Object)NumberFormat.getInstance().parse(min));
        }
        catch (ParseException e) {
            throw new RuntimeException("\u53c2\u6570\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6570\u5b57\u7c7b\u578b\u7684\u5b57\u7b26\u4e32: \u53c2\u6570\u503c=" + min, e);
        }
        try {
            range.lt((Object)NumberFormat.getInstance().parse(max));
        }
        catch (ParseException e) {
            throw new RuntimeException("\u53c2\u6570\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6570\u5b57\u7c7b\u578b\u7684\u5b57\u7b26\u4e32: \u53c2\u6570\u503c=" + max, e);
        }
        return range;
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K key, String min, String max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = (Set)this.execute(connection -> {
            RedisZSetCommands.Range range = this.getRange(min, max);
            RedisZSetCommands.Limit limit = RedisZSetCommands.Limit.limit();
            limit.offset(new Long(offset).intValue());
            limit.count(new Long(count).intValue());
            return connection.zRangeByScoreWithScores(rawKey, range, limit);
        }, true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Long removeRangeByScore(K key, String min, String max) {
        byte[] rawKey = this.rawKey(key);
        return (Long)this.execute(connection -> {
            RedisZSetCommands.Range range = this.getRange(min, max);
            return connection.zRemRangeByScore(rawKey, range);
        }, true);
    }

    @Override
    public Long removeRange(K key, String start, String end) {
        byte[] rawKey = this.rawKey(key);
        return (Long)this.execute(connection -> {
            RedisZSetCommands.Range range = this.getRange(start, end);
            return connection.zRemRangeByScore(rawKey, range);
        }, true);
    }
}

