/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.eo;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseDefEo;
import com.dtyunxi.eo.BaseEoUtil;
import com.dtyunxi.eo.CamelToUnderline;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.ReflectUtil;
import com.dtyunxi.util.SqlUtil;
import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEo
extends BaseVo {
    private static final long serialVersionUID = -6797987329209542967L;
    private static final transient Logger logger = LoggerFactory.getLogger(BaseEo.class);
    private static transient Map<Class<? extends BaseEo>, List<Map<String, String>>> mapColumns = new HashMap<Class<? extends BaseEo>, List<Map<String, String>>>();
    private static transient Map<Class<? extends BaseEo>, String> mapId = new HashMap<Class<? extends BaseEo>, String>();
    private transient String extWhere;
    @Id
    protected Long id;
    @Column(name="tenant_id")
    private Long tenantId;
    @Column(name="create_person")
    private String createPerson;
    @Column(name="create_time")
    private Date createTime;
    @Column(name="update_person")
    private String updatePerson;
    @Column(name="update_time")
    private Date updateTime;
    @Column
    private Integer dr = 0;
    @JsonIgnore
    @Transient
    private String orderByDesc;
    @JsonIgnore
    @Transient
    private String orderBy;
    @JsonIgnore
    @Transient
    private List<SqlFilter> sqlFilters;
    @Transient
    private String EO_ATTRIBUTE = "eoAttribute";
    @Transient
    private String TAB_COLUMN = "tabColumn";

    public String getExtWhere() {
        return this.extWhere;
    }

    public void setExtWhere(String extWhere) {
        this.extWhere = extWhere;
    }

    public List<SqlFilter> getSqlFilters() {
        return this.sqlFilters;
    }

    public void setSqlFilters(List<SqlFilter> sqlFilters) {
        this.sqlFilters = sqlFilters;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getCreatePerson() {
        return this.createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+08:00")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+08:00")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getDr() {
        return this.dr;
    }

    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public void setDr(int dr) {
        this.dr = dr;
    }

    public String getOrderByDesc() {
        return this.orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String tableName() {
        return BaseEoUtil.tableName(this.getClass());
    }

    public String idName() {
        String idFieldName = mapId.get(this.getClass());
        if (idFieldName == null) {
            idFieldName = BaseEoUtil.idName(this.getClass());
            mapId.put(this.getClass(), idFieldName);
        }
        return idFieldName;
    }

    private boolean isWhereNull(String fieldName) {
        try {
            return this.fieldValueWhere(this.getClass(), fieldName);
        }
        catch (Exception e) {
            for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    if (clazz != BaseDefEo.class) continue;
                    return this.fieldValueWhere(clazz, fieldName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    private boolean fieldValueWhere(Class clazz, String fieldName) throws Exception {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(this) == null || "".equals(field.get(this));
    }

    private boolean isNull(String fieldName) {
        try {
            return this.fieldValueBoolean(this.getClass(), fieldName);
        }
        catch (Exception e) {
            for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    if (clazz != BaseDefEo.class) continue;
                    return this.fieldValueBoolean(clazz, fieldName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    private boolean fieldValueBoolean(Class clazz, String fieldName) throws Exception {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(this) == null;
    }

    private void calcColumnList() {
        if (mapColumns.containsKey(this.getClass())) {
            return;
        }
        ArrayList columnList = new ArrayList();
        HashMap<String, String> map = null;
        String columnName = null;
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field[] declaredFields;
                if (clazz == BaseEo.class) continue;
                for (Field field : declaredFields = clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Column.class)) continue;
                    Column column = field.getAnnotation(Column.class);
                    columnName = field.getName();
                    map = new HashMap<String, String>();
                    map.put(this.EO_ATTRIBUTE, columnName);
                    map.put(this.TAB_COLUMN, !"".equals(column.name()) ? column.name() : CamelToUnderline.camelToUnderline(columnName));
                    columnList.add(map);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mapColumns.put(this.getClass(), columnList);
    }

    public String returnSelectColumnsName() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map<String, String> map : this.getColumnList()) {
            if (i++ != 0) {
                sb.append(',');
            } else {
                sb.append("id,create_time as createTime,create_person as createPerson,update_time as updateTime,update_person as updatePerson,tenant_id as tenantId,dr as dr,");
            }
            sb.append(map.get(this.TAB_COLUMN));
            sb.append(" as ");
            sb.append(map.get(this.EO_ATTRIBUTE));
        }
        return sb.toString();
    }

    public String returnInsertColumnsName() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder("id,");
        for (Map<String, String> map : this.getColumnList()) {
            if (this.isNull(map.get(this.EO_ATTRIBUTE))) continue;
            sb.append(map.get(this.TAB_COLUMN)).append(",");
        }
        sb.append(this.insertColumn());
        return sb.toString();
    }

    public String returnInsertColumnsDef() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        for (Map<String, String> map : this.getColumnList()) {
            if (this.isNull(map.get(this.EO_ATTRIBUTE))) continue;
            sb.append("#{").append(map.get(this.EO_ATTRIBUTE)).append("},");
        }
        sb.append(this.insertValue(false));
        return sb.toString();
    }

    public String returnInsertColumnsNameBatch() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder("id,");
        for (Map<String, String> map : this.getColumnList()) {
            sb.append(map.get(this.TAB_COLUMN)).append(",");
        }
        sb.append(this.insertColumn());
        return sb.toString();
    }

    public String returnInsertColumnsDefBatch() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        for (Map<String, String> map : this.getColumnList()) {
            sb.append("#'{'objList[{0}].").append(map.get(this.EO_ATTRIBUTE)).append("'}',");
        }
        sb.append(this.insertValue(true)).append(")");
        return sb.toString();
    }

    private String insertColumn() {
        StringBuilder sb = new StringBuilder();
        sb.append("create_time,update_time,create_person,tenant_id,update_person,dr");
        return sb.toString();
    }

    private String insertValue(Boolean isBatch) {
        String tenantId;
        StringBuilder sb = new StringBuilder();
        sb.append("now(),now(),");
        String createPerson = ServiceContext.getContext().getRequestUserCode();
        if (StringUtils.isEmpty((CharSequence)createPerson)) {
            createPerson = "#createPerson";
        }
        if ((tenantId = String.valueOf(ServiceContext.getContext().getRequestTenantId())) == null || "0".equals(tenantId)) {
            tenantId = "#tenantId";
        }
        if (isBatch.booleanValue()) {
            sb.append("''").append(createPerson).append("''").append(",").append(tenantId).append(",''").append(createPerson).append("'',#'{'objList[{0}].dr'}'");
        } else {
            sb.append("'").append(createPerson).append("'").append(",").append(tenantId).append(",'").append(createPerson).append("',#{dr}");
        }
        return sb.toString();
    }

    public String returnUpdateSet() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (this.getColumnList() != null && this.getColumnList().size() > 0) {
            sb.append(this.updateColumn());
            i = 1;
        }
        for (Map<String, String> map : this.getColumnList()) {
            if (i++ != 0) {
                sb.append(',');
            }
            sb.append(map.get(this.TAB_COLUMN)).append("=#{").append(map.get(this.EO_ATTRIBUTE)).append('}');
        }
        return sb.toString();
    }

    private String updateColumn() {
        String tenantId;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("dr").append("=#{dr},");
        stringBuilder.append("update_time").append("=now()");
        String createPerson = ServiceContext.getContext().getRequestUserCode();
        if (StringUtils.isNotEmpty((CharSequence)createPerson)) {
            stringBuilder.append(",update_person").append("='").append(createPerson).append("'");
        }
        if ((tenantId = String.valueOf(ServiceContext.getContext().getRequestTenantId())) != null && !"0".equals(tenantId)) {
            stringBuilder.append(",tenant_id").append("=").append(tenantId);
        }
        return stringBuilder.toString();
    }

    public String returnUpdateSetNotNull() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (this.getColumnList() != null && this.getColumnList().size() > 0) {
            sb.append(this.updateColumn());
            i = 1;
        }
        for (Map<String, String> map : this.getColumnList()) {
            if (this.isNull(map.get(this.EO_ATTRIBUTE))) continue;
            if (i++ != 0) {
                sb.append(',');
            }
            sb.append(map.get(this.TAB_COLUMN)).append("=#{").append(map.get(this.EO_ATTRIBUTE)).append('}');
        }
        return sb.toString();
    }

    public String returnWhereColumnNames() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        String columns = ",";
        if (this.sqlFilters != null && this.sqlFilters.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (SqlFilter sqlFilter : this.sqlFilters) {
                if (sqlFilter == null || StringUtils.isEmpty((CharSequence)sqlFilter.getProperty())) continue;
                if (!"".equals(sb.toString())) {
                    sb.append(" and ");
                }
                sb.append(this.getSqlFilterWhere(sqlFilter, sdf));
                columns = columns + sqlFilter.getProperty() + ",";
            }
        }
        String col = ",id,dr,";
        if (columns.indexOf("dr") == -1) {
            if (!"".equals(sb.toString())) {
                sb.append(" and ");
            }
            if (this.getDr() == 1) {
                sb.append("dr").append("=1");
            } else {
                sb.append("dr").append("=0");
            }
        }
        for (Map map : this.getColumnList()) {
            if (this.isWhereNull((String)map.get(this.EO_ATTRIBUTE)) || columns.indexOf(col = "," + (String)map.get(this.EO_ATTRIBUTE) + ",") != -1) continue;
            if (!"".equals(sb.toString())) {
                sb.append(" and ");
            }
            sb.append((String)map.get(this.TAB_COLUMN)).append("=#{").append((String)map.get(this.EO_ATTRIBUTE)).append("}");
        }
        return sb.toString();
    }

    private String getSqlFilterWhere(SqlFilter filter, SimpleDateFormat sdf) {
        StringBuilder sqlWhere = new StringBuilder();
        sqlWhere.append(CamelToUnderline.camelToUnderline(filter.getProperty()));
        if (filter.getOperator() == SqlFilter.Operator.eq && filter.getValue() != null) {
            if (filter.getValue() instanceof String) {
                sqlWhere.append(" = '").append(filter.getValue() + "'");
            } else {
                sqlWhere.append(" = ").append(filter.getValue());
            }
        } else if (filter.getOperator() == SqlFilter.Operator.ne && filter.getValue() != null) {
            if (filter.getValue() instanceof String) {
                sqlWhere.append(" <> '").append(filter.getValue() + "'");
            } else {
                sqlWhere.append(" <> ").append(filter.getValue());
            }
        } else if ((filter.getOperator() == SqlFilter.Operator.gt || filter.getOperator() == SqlFilter.Operator.lt) && filter.getValue() != null) {
            String time = " 00:00:01'";
            if (filter.getOperator() == SqlFilter.Operator.gt) {
                sqlWhere.append(" > ");
            } else {
                sqlWhere.append(" < ");
                time = " 23:59:59'";
            }
            if (filter.getValue() instanceof Date) {
                sqlWhere.append("'").append(sdf.format(filter.getValue())).append(time);
            } else if (filter.getValue() instanceof String) {
                sqlWhere.append("'").append(filter.getValue()).append("'");
            } else {
                sqlWhere.append(filter.getValue());
            }
        } else if ((filter.getOperator() == SqlFilter.Operator.ge || filter.getOperator() == SqlFilter.Operator.le) && filter.getValue() != null) {
            if (filter.getOperator() == SqlFilter.Operator.ge) {
                sqlWhere.append(" >= ");
            } else {
                sqlWhere.append(" <= ");
            }
            if (filter.getValue() instanceof Date) {
                sqlWhere.append("'").append(sdf.format(filter.getValue())).append("'");
            } else if (filter.getValue() instanceof String) {
                sqlWhere.append("'").append(filter.getValue()).append("'");
            } else {
                sqlWhere.append(filter.getValue());
            }
        } else if (filter.getOperator() == SqlFilter.Operator.like && filter.getValue() != null) {
            String value = this.likeValue(filter.getValue().toString());
            sqlWhere.append(" like '").append(value.replaceAll("'", "''")).append("'");
        } else if (filter.getOperator() == SqlFilter.Operator.in && filter.getValue() != null) {
            String filterValue = this.processOperatorInValue(filter);
            if (StringUtils.isNotBlank((CharSequence)filterValue)) {
                sqlWhere.append(" in (").append(filterValue).append(")");
            }
        } else if (filter.getOperator() == SqlFilter.Operator.isNull) {
            sqlWhere.append(" is null");
        } else if (filter.getOperator() == SqlFilter.Operator.isNotNull) {
            sqlWhere.append(" is not null");
        }
        return sqlWhere.toString();
    }

    protected String processOperatorInValue(SqlFilter filter) {
        if (filter == null || filter.getValue() == null) {
            return null;
        }
        ArrayList processedValues = Lists.newArrayList();
        try {
            Field field = ReflectUtil.getField(this.getClass(), CamelToUnderline.underlineToCamel(filter.getProperty()));
            Class<?> fieldClass = field.getType();
            if (String.class.equals(fieldClass)) {
                Object filterValue = filter.getValue();
                if (filterValue instanceof String) {
                    String[] splitValues;
                    for (String splitValue : splitValues = ((String)filterValue).split(",")) {
                        if (!splitValue.startsWith("'")) {
                            splitValue = "'" + splitValue;
                        }
                        if (!splitValue.endsWith("'")) {
                            splitValue = splitValue + "'";
                        }
                        processedValues.add(splitValue);
                    }
                } else if (filterValue instanceof List) {
                    List listFilterValues = (List)filterValue;
                    for (Object listValue : listFilterValues) {
                        if (listValue == null) continue;
                        if (listValue instanceof String) {
                            String processValue = (String)listValue;
                            if (!processValue.startsWith("'")) {
                                processValue = "'" + processValue;
                            }
                            if (!processValue.endsWith("'")) {
                                processValue = processValue + "'";
                            }
                            processedValues.add(processValue);
                            continue;
                        }
                        processedValues.add("'" + listValue + "'");
                    }
                } else {
                    processedValues.add("'" + filterValue + "'");
                }
                return Joiner.on((String)",").skipNulls().join((Iterable)processedValues).toString();
            }
            if (filter.getValue() instanceof List) {
                return Joiner.on((String)",").skipNulls().join((Iterable)((List)filter.getValue())).toString();
            }
            return filter.getValue().toString();
        }
        catch (Exception e) {
            logger.error("sqlfiter\u4f20\u5165\u7684property\u6709\u8bef", (Throwable)e);
            return null;
        }
    }

    private String likeValue(String value) {
        String v;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        int start = 0;
        int end = value.length();
        String startValue = "";
        String endValue = "";
        if ("%".equals(value.substring(0, 1))) {
            start = 1;
            startValue = "%";
        }
        if ("%".equals(value.substring(value.length() - 1, value.length()))) {
            end = value.length() - 1;
            endValue = "%";
        }
        if ((v = value.substring(start, end)).indexOf("%") != -1) {
            value = startValue + v.replaceAll("%", "[%]") + endValue;
        }
        return value;
    }

    public String returnUpdateWhereColumnNames() {
        StringBuilder sb = new StringBuilder();
        if (this.sqlFilters != null && this.sqlFilters.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (SqlFilter filter : this.sqlFilters) {
                if (filter == null || StringUtils.isEmpty((CharSequence)filter.getProperty())) continue;
                if (!"".equals(sb.toString())) {
                    sb.append(" and ");
                }
                sb.append(this.getSqlFilterWhere(filter, sdf));
            }
            if (StringUtils.isNotEmpty((CharSequence)sb) && !SqlUtil.isSpiteParams(sb.toString().toLowerCase())) {
                logger.error("Malice SQL keyword : {}", (Object)sb.toString());
            }
        }
        return sb.toString();
    }

    public String resultOrderBy() {
        String[] strs;
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this.orderByDesc)) {
            for (String s : strs = this.orderByDesc.split(",")) {
                if (!"".equals(sb.toString())) {
                    sb.append(",");
                }
                sb.append(CamelToUnderline.camelToUnderline(s)).append(" desc");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.orderBy)) {
            for (String s : strs = this.orderBy.split(",")) {
                if (!"".equals(sb.toString())) {
                    sb.append(",");
                }
                sb.append(CamelToUnderline.camelToUnderline(s)).append(" asc");
            }
        }
        if ("".equals(sb.toString())) {
            sb.append("id").append(" desc");
        }
        return sb.toString();
    }

    private List<Map<String, String>> getColumnList() {
        return mapColumns.get(this.getClass());
    }

    public String toString() {
        Field[] fields = this.getClass().getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Field f : fields) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
            Object value = null;
            try {
                f.setAccessible(true);
                value = f.get(this);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (value == null) continue;
            sb.append(f.getName()).append('=').append(value).append(',');
        }
        sb.append(']');
        return sb.toString();
    }
}

