/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.eo;

import java.io.Serializable;

public class SqlFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String property;
    private Operator operator;
    private Object value;

    public SqlFilter() {
    }

    public SqlFilter(String property, Operator operator, Object value) {
        this.property = property;
        this.operator = operator;
        this.value = value;
    }

    public static SqlFilter eq(String property, Object value) {
        return new SqlFilter(property, Operator.eq, value);
    }

    public static SqlFilter ne(String property, Object value) {
        return new SqlFilter(property, Operator.ne, value);
    }

    public static SqlFilter gt(String property, Object value) {
        return new SqlFilter(property, Operator.gt, value);
    }

    public static SqlFilter lt(String property, Object value) {
        return new SqlFilter(property, Operator.lt, value);
    }

    public static SqlFilter ge(String property, Object value) {
        return new SqlFilter(property, Operator.ge, value);
    }

    public static SqlFilter le(String property, Object value) {
        return new SqlFilter(property, Operator.le, value);
    }

    public static SqlFilter like(String property, Object value) {
        return new SqlFilter(property, Operator.like, value);
    }

    public static SqlFilter in(String property, Object value) {
        return new SqlFilter(property, Operator.in, value);
    }

    public static SqlFilter isNull(String property) {
        return new SqlFilter(property, Operator.isNull, null);
    }

    public static SqlFilter isNotNull(String property) {
        return new SqlFilter(property, Operator.isNotNull, null);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static enum Operator {
        eq,
        ne,
        gt,
        lt,
        ge,
        le,
        like,
        in,
        isNull,
        isNotNull;


        public static Operator fromString(String value) {
            return Operator.valueOf(value.toLowerCase());
        }
    }
}

