/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.aop;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.datalimit.service.IMetaDataQueryService;
import com.dtyunxi.huieryun.datalimit.utils.ControlledEntityHolder;
import com.dtyunxi.huieryun.datalimit.utils.DataLimitContext;
import com.dtyunxi.huieryun.datalimit.utils.DataLimitRuleHandler;
import com.dtyunxi.huieryun.util.EoUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.persistence.Table;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Aspect
public class DataLimitAspect {
    private static final Logger logger = LoggerFactory.getLogger(DataLimitAspect.class);
    public static final String ALL_SKIP_TABLE = "*";
    private static final Set<String> ALL_SKIP_TABLE_SET = new HashSet<String>(1);
    private DataLimitRuleHandler dataLimitRuleHandler;
    private IMetaDataQueryService metaDataQueryService;
    private static final ThreadLocal<Map<String, Integer>> localStackMap;
    private static final ThreadLocal<Page<Object>> pageHelperThreadLocal;
    private static final ThreadLocal<Set<String>> skipPermissionTables;

    public DataLimitAspect(DataLimitRuleHandler dataLimitRuleHandler, IMetaDataQueryService metaDataQueryService) {
        this.dataLimitRuleHandler = dataLimitRuleHandler;
        this.metaDataQueryService = metaDataQueryService;
        logger.debug("\u6570\u636e\u6743\u9650\u62e6\u622a\u5df2\u5f00\u542f");
    }

    @Around(value="execution(* com.dtyunxi.cube.framework.das.ComBaseDas+.*(..)) && !execution(* com.dtyunxi.cube.framework.das.ComBaseDas+.exists(..))")
    public Object checkPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> eoClass = EoUtil.getGenericClass(joinPoint.getTarget().getClass());
        if (null == eoClass) {
            throw new IllegalStateException("Das \u7ee7\u627f\u7ed3\u6784\u4e0d\u6807\u51c6\uff01");
        }
        joinPoint.getTarget();
        if (!eoClass.isAnnotationPresent(Table.class)) {
            throw new IllegalStateException(eoClass.getName() + "\u4e2d,Table\u6ce8\u89e3\u4e0d\u5b58\u5728\uff01");
        }
        String tableName = eoClass.getAnnotation(Table.class).name();
        try {
            if (this.skipEntityControl(tableName)) {
                logger.debug("\u8868{}\u5728\u5f53\u524d\u7ebf\u7a0b\u4e2d\u914d\u7f6e\u4e86\u5ffd\u7565\u6570\u636e\u6743\u9650\u3002", (Object)tableName);
            } else if (this.metaDataQueryService.isEntityUnderControl(tableName)) {
                this.setDasControl(joinPoint, tableName);
                logger.debug("{} \u662f\u53d7\u63a7\u5bf9\u8c61", (Object)tableName);
                if (!this.isAlreadyControl(tableName)) {
                    List<String> subQueryList = this.dataLimitRuleHandler.getDataLimitSQL(eoClass, tableName);
                    if (!CollectionUtils.isEmpty(subQueryList)) {
                        DataLimitContext.addLimitRule(tableName, subQueryList);
                        logger.debug("\u83b7\u53d6\u5230\u89c4\u5219:{}", JSON.toJSON(subQueryList));
                    } else {
                        logger.info("\u53d7\u63a7\u5bf9\u8c61{}\u6ca1\u6709\u83b7\u53d6\u5230\u6570\u636e\u6743\u9650\u89c4\u5219!", (Object)tableName);
                    }
                    this.startPageHelper();
                }
            } else {
                logger.debug("{} \u4e0d\u662f\u53d7\u63a7\u5bf9\u8c61\uff0c\u4e0d\u8fdb\u884c\u6570\u636e\u6743\u9650\u5904\u7406\u3002", (Object)tableName);
            }
            Object[] args = joinPoint.getArgs();
            Object result = joinPoint.proceed(args);
            DataLimitContext.clear();
            Object object = result;
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.clearStack(tableName);
        }
    }

    private boolean skipEntityControl(String tableName) {
        Set<String> tables = skipPermissionTables.get();
        if (tables == null) {
            return false;
        }
        if (tables.contains(ALL_SKIP_TABLE)) {
            return true;
        }
        return tables.contains(tableName.toLowerCase(Locale.ROOT));
    }

    public static void skipAllTable() {
        if (logger.isDebugEnabled()) {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            logger.debug("{} line:{},\u65b9\u6cd5:{}\u8bbe\u7f6e\u4e86\u8df3\u8fc7\u6240\u6709\u8868", new Object[]{trace[0].getClassName(), trace[0].getLineNumber(), trace[0].getMethodName()});
        }
        skipPermissionTables.set(ALL_SKIP_TABLE_SET);
    }

    public static void skipAllTable(Consumer<Set<String>> consumer) {
        DataLimitAspect.skipAllTable();
        consumer.accept(ALL_SKIP_TABLE_SET);
    }

    public static void cleanSkipTable() {
        skipPermissionTables.remove();
        logger.debug("\u6570\u636e\u6743\u9650\u5ffd\u7565\u8868\u914d\u7f6e\u5df2\u6e05\u7406");
    }

    public static Set<String> readSkipTable() {
        return skipPermissionTables.get();
    }

    public static Set<String> readSkipTable(Supplier<Set<String>> supplier) {
        Set<String> hystrixSkipTable = supplier.get();
        if (!CollectionUtils.isEmpty(hystrixSkipTable)) {
            return hystrixSkipTable;
        }
        return DataLimitAspect.readSkipTable();
    }

    public static void skipTables(String ... tables) {
        if (tables == null || tables.length == 0) {
            skipPermissionTables.remove();
            if (logger.isDebugEnabled()) {
                StackTraceElement[] trace = Thread.currentThread().getStackTrace();
                logger.debug("{} line:{},\u65b9\u6cd5:{}\u6e05\u7a7a\u4e86\u5ffd\u7565\u8868\u914d\u7f6e", new Object[]{trace[0].getClassName(), trace[0].getLineNumber(), trace[0].getMethodName()});
            }
        } else {
            skipPermissionTables.set(new HashSet(tables.length));
            for (String table : tables) {
                skipPermissionTables.get().add(table);
            }
            if (logger.isDebugEnabled()) {
                Object[] trace = Thread.currentThread().getStackTrace();
                logger.debug("{} line:{},\u65b9\u6cd5:{}\u8bbe\u7f6e\u4e86\u5ffd\u7565\u8868:{}", new Object[]{((StackTraceElement)trace[0]).getClassName(), ((StackTraceElement)trace[0]).getLineNumber(), ((StackTraceElement)trace[0]).getMethodName(), tables});
            }
        }
    }

    public static void skipTables(Consumer<Set<String>> consumer, String ... tables) {
        DataLimitAspect.skipTables(tables);
        consumer.accept(skipPermissionTables.get());
    }

    private void setDasControl(ProceedingJoinPoint joinPoint, String tableName) {
        if (!ControlledEntityHolder.hasTable(tableName)) {
            try {
                ReflectUtil.invoke((Object)joinPoint.getTarget(), (String)"setEntityUnderControl", (Object[])new Object[]{true});
            }
            catch (Exception e) {
                logger.warn("\u8bbe\u7f6eDas\u5bf9\u8c61entityUnderControl\u5c5e\u6027\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bcube-framework-core\u7248\u672c\uff01{}", (Object)e.getMessage());
            }
            ControlledEntityHolder.addTable(tableName);
        }
    }

    private boolean isAlreadyControl(String tableName) {
        Map<String, Integer> stringIntegerMap = localStackMap.get();
        if (stringIntegerMap == null) {
            Page localPage = PageHelper.getLocalPage();
            if (localPage != null && localPage.getPageNum() > 0) {
                PageHelper.clearPage();
                pageHelperThreadLocal.set((Page<Object>)localPage);
            }
            stringIntegerMap = new HashMap<String, Integer>(16);
            stringIntegerMap.put(tableName, 1);
            localStackMap.set(stringIntegerMap);
            return false;
        }
        Integer integer = stringIntegerMap.get(tableName);
        if (integer == null || integer == 0) {
            stringIntegerMap.put(tableName, 1);
            return false;
        }
        Integer n = integer;
        Integer n2 = integer = Integer.valueOf(integer + 1);
        stringIntegerMap.put(tableName, integer);
        if (logger.isDebugEnabled()) {
            logger.debug("{}\u8868\u5728\u5f53\u524d\u7ebf\u7a0b {} \u5df2\u7ecf\u62e6\u622a\u8fc7\u4e86", (Object)tableName, (Object)Thread.currentThread().getId());
        }
        return true;
    }

    private void clearStack(String key) {
        Map<String, Integer> stringIntegerMap = localStackMap.get();
        if (stringIntegerMap == null) {
            return;
        }
        Integer integer = stringIntegerMap.get(key);
        if (integer != null) {
            if (integer > 1) {
                Integer n = integer;
                Integer n2 = integer = Integer.valueOf(integer - 1);
                stringIntegerMap.put(key, integer);
            } else {
                stringIntegerMap.remove(key);
            }
        }
        if (stringIntegerMap.isEmpty()) {
            localStackMap.remove();
        }
    }

    private void startPageHelper() {
        Page<Object> objects;
        Map<String, Integer> stringIntegerMap = localStackMap.get();
        if (stringIntegerMap != null && stringIntegerMap.size() == 1 && (objects = pageHelperThreadLocal.get()) != null && objects.getPageNum() > 0) {
            PageHelper.startPage((int)objects.getPageNum(), (int)objects.getPageSize(), (boolean)objects.isCount(), (Boolean)objects.getReasonable(), (Boolean)objects.getPageSizeZero());
            pageHelperThreadLocal.remove();
        }
    }

    static {
        ALL_SKIP_TABLE_SET.add(ALL_SKIP_TABLE);
        localStackMap = new ThreadLocal();
        pageHelperThreadLocal = new ThreadLocal();
        skipPermissionTables = new ThreadLocal();
    }
}

