/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.utils;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.datalimit.dto.UserDataLimitRuleDto;
import com.dtyunxi.huieryun.datalimit.service.IDataLimitRuleQueryService;
import com.dtyunxi.huieryun.datalimit.utils.FunctionHandler;
import com.dtyunxi.huieryun.datalimit.utils.RuleResolver;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DataLimitRuleHandler {
    private static final Logger logger = LoggerFactory.getLogger(DataLimitRuleHandler.class);
    private IDataLimitRuleQueryService dataLimitRuleQueryService;
    private FunctionHandler functionHandler;
    private RuleResolver ruleResolver;
    private ICacheService cacheService;
    private Integer userRuleCacheTime;
    private boolean cacheAvailable;

    public DataLimitRuleHandler(IDataLimitRuleQueryService dataLimitRuleQueryService, FunctionHandler functionHandler, RuleResolver ruleResolver) {
        this.dataLimitRuleQueryService = dataLimitRuleQueryService;
        this.functionHandler = functionHandler;
        this.ruleResolver = ruleResolver;
    }

    public DataLimitRuleHandler(IDataLimitRuleQueryService dataLimitRuleQueryService, FunctionHandler functionHandler, RuleResolver ruleResolver, ICacheService cacheService, Integer userRuleCacheTime) {
        this.dataLimitRuleQueryService = dataLimitRuleQueryService;
        this.functionHandler = functionHandler;
        this.ruleResolver = ruleResolver;
        this.cacheAvailable = null != cacheService;
        this.cacheService = cacheService;
        this.userRuleCacheTime = userRuleCacheTime;
    }

    public List<String> getDataLimitSQL(Class<?> eoClass, String tableName) {
        List cacheRuleList;
        Long userId = ServiceContext.getContext().getRequestUserId();
        if (null == userId) {
            logger.warn("\u5f53\u524d\u7528\u6237id\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u83b7\u53d6\u5230 {} \u5bf9\u5e94\u7684\u6570\u636e\u6743\u9650\uff01", (Object)tableName);
            return Lists.newArrayList();
        }
        String cacheKey = this.getRuleCacheKey(userId, tableName);
        if (this.cacheAvailable && StringUtils.hasText((String)cacheKey) && null != (cacheRuleList = (List)this.cacheService.getCache(null, cacheKey, (TypeReference)new TypeReference<List<String>>(){}))) {
            this.cacheService.expire(null, cacheKey, this.userRuleCacheTime.intValue());
            if (logger.isDebugEnabled()) {
                logger.debug("use user rule cache ,cacheKey:{}, value:{}", (Object)cacheKey, (Object)JSON.toJSONString((Object)cacheRuleList));
            }
            return cacheRuleList;
        }
        UserDataLimitRuleDto userDataLimitRuleDto = this.dataLimitRuleQueryService.getRuleList(userId, tableName);
        List<String> ruleList = userDataLimitRuleDto.getRuleList();
        if (CollectionUtils.isEmpty(ruleList)) {
            if (userDataLimitRuleDto.isHasOtherSceneRule()) {
                return Lists.newArrayList((Object[])new String[]{"1!=1"});
            }
            return Lists.newArrayList();
        }
        ArrayList resolvedRuleList = Lists.newArrayList();
        for (String dataLimitStr : ruleList) {
            logger.debug("\u5f00\u59cb\u89e3\u6790\u89c4\u5219\uff1a{}", (Object)dataLimitStr);
            String roleRuleCondition = this.parserRoleRule(eoClass, dataLimitStr);
            if ("1!=1".equals(roleRuleCondition) || StringUtils.isEmpty((Object)roleRuleCondition)) continue;
            resolvedRuleList.add(roleRuleCondition);
        }
        ruleList = this.mergeRules(resolvedRuleList);
        if (logger.isDebugEnabled()) {
            logger.debug("\u89e3\u6790\u540e\u7684\u89c4\u5219\u5217\u8868:{}", (Object)JSON.toJSONString(ruleList));
        }
        if (this.cacheAvailable && StringUtils.hasText((String)cacheKey)) {
            this.cacheService.setCache(null, cacheKey, ruleList, this.userRuleCacheTime.intValue());
            logger.debug("set user rule cache ,cacheKey:{}", (Object)cacheKey);
        }
        return ruleList;
    }

    private String getRuleCacheKey(Long userId, String tableName) {
        String requestId = ServiceContext.getContext().getRequestId();
        if (StringUtils.isEmpty((Object)requestId)) {
            logger.warn("requestId is null, can not use rule cache");
            return null;
        }
        StringBuilder cacheKey = new StringBuilder("DataLimitRule:");
        cacheKey.append(requestId).append(":").append(userId).append(":").append("rule").append(":").append(tableName);
        return cacheKey.toString();
    }

    public String parserRoleRule(Class<?> eoClass, String roleRule) {
        ArrayList<String> groupRules = new ArrayList<String>();
        String regex = "\\[(.*?)]";
        Pattern compile = Pattern.compile(regex);
        Matcher matcher = compile.matcher(roleRule);
        while (matcher.find()) {
            groupRules.add(matcher.group(1));
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String group : groupRules) {
            String funcResult = this.functionHandler.replaceFunctionWithValue(group);
            if ("1!=1".equals(funcResult)) {
                logger.warn("\u51fd\u6570\u8c03\u7528\u7ed3\u679c\u4e3a\u7a7a\uff0c\u5ffd\u7565\u6b64\u5206\u7ec4\u6761\u4ef6\uff1a {}", (Object)group);
                continue;
            }
            list.add(this.parserGroupRule(eoClass, funcResult));
        }
        if (list.isEmpty()) {
            return "1!=1";
        }
        return this.mergeConditionToString("OR", list);
    }

    public List<String> mergeRules(List<String> list) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.mergeConditionToString("OR", list));
        return result;
    }

    public String parserGroupRule(Class<?> eoClass, String roleRule) {
        List<String> strings = this.ruleResolver.resolve2Sql(eoClass, roleRule);
        return this.mergeConditionToString("AND", strings);
    }

    public String mergeConditionToString(String operator, List<String> conditions) {
        return " (" + String.join((CharSequence)(" " + operator + " "), conditions) + " )";
    }
}

