/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.utils;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.util.JdbcUtils;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.mapping.BoundSql;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static Logger logger = LoggerFactory.getLogger(SqlUtil.class);
    private static Set<String> COUNT_TABLE_ALIAS_SET = new HashSet<String>(16);

    public static String appendDataLimit(String originSql, String conditionStr) {
        return SqlUtil.appendAndCondition(originSql, conditionStr);
    }

    public static String appendAndCondition(String sql, String whereConditionStr) {
        return SqlUtil.appendCondition(sql, whereConditionStr, SQLBinaryOperator.BooleanAnd);
    }

    public static String appendCondition(String sql, String whereConditionStr, SQLBinaryOperator sqlBinaryOperator) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)JdbcUtils.MYSQL);
        List stmtList = parser.parseStatementList();
        SQLStatement stmt = (SQLStatement)stmtList.get(0);
        if (stmt instanceof SQLSelectStatement) {
            SQLExprParser constraintsParser = SQLParserUtils.createExprParser((String)whereConditionStr, (DbType)JdbcUtils.MYSQL, (SQLParserFeature[])new SQLParserFeature[0]);
            SQLExpr constraintsExpr = constraintsParser.expr();
            SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
            SQLSelect sqlselect = selectStmt.getSelect();
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)sqlselect.getQuery();
            SQLExpr whereExpr = query.getWhere();
            if (whereExpr == null) {
                query.setWhere(constraintsExpr);
            } else {
                SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr(whereExpr, sqlBinaryOperator, constraintsExpr);
                query.setWhere((SQLExpr)newWhereExpr);
            }
            sqlselect.setQuery((SQLSelectQuery)query);
            sql = sqlselect.toString();
        }
        return sql;
    }

    public static String getTableAlias(String tableName, String selectSql) {
        SQLSelectQueryBlock query = SqlUtil.getSqlSelectQueryBlock(selectSql);
        SQLTableSource tableSource = query.getFrom().findTableSource(tableName);
        if (null == tableSource) {
            String errorMsg = "\u67e5\u8be2\u8bed\u53e5\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u5728\u67e5\u8be2\u4e2d\u6ca1\u6709\u5305\u542b\u53d7\u63a7\u8868\uff1a" + tableName;
            logger.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        String alias = tableSource.computeAlias();
        if (tableName.equalsIgnoreCase(alias)) {
            return null;
        }
        return alias;
    }

    public static boolean isPageHelperCountQuery(String sql) {
        SQLSelectQueryBlock query = SqlUtil.getSqlSelectQueryBlock(sql);
        String outAlias = query.getFrom().computeAlias();
        return COUNT_TABLE_ALIAS_SET.contains(outAlias);
    }

    public static String getRealSql(String originSql) {
        SQLSelectQueryBlock query = SqlUtil.getSqlSelectQueryBlock(originSql);
        String outAlias = query.getFrom().computeAlias();
        if (COUNT_TABLE_ALIAS_SET.contains(outAlias)) {
            SQLSubqueryTableSource subQueryTableSource = (SQLSubqueryTableSource)query.getFrom();
            String realSql = subQueryTableSource.getSelect().toString();
            return realSql;
        }
        return originSql;
    }

    public static String addTableAlias(String tableName, String tableAlias, String selectSql) {
        SQLSelectQueryBlock query = SqlUtil.getSqlSelectQueryBlock(selectSql);
        query.getFrom().findTableSource(tableName).setAlias(tableAlias);
        return query.toString();
    }

    private static SQLSelectQueryBlock getSqlSelectQueryBlock(String selectSql) {
        MySqlStatementParser parser = new MySqlStatementParser(selectSql);
        SQLStatement stmt = parser.parseStatement();
        SQLSelect sqlSelect = ((SQLSelectStatement)stmt).getSelect();
        return (SQLSelectQueryBlock)sqlSelect.getQuery();
    }

    public static String commonRule2Sql(String commonRule, String mainTableName) {
        commonRule = commonRule.toUpperCase().replace(mainTableName.toUpperCase() + ".", "mt_alias_sub.");
        return (" exists( select 1 from " + mainTableName + " " + "mt_alias_sub" + " where " + commonRule + " and " + "mt_alias_sub" + ".id=" + "MAIN_TABLE_ALIAS" + ".id) ").toUpperCase();
    }

    public static String getCommonRuleSubQuery(String commonRule, String mainTableName) {
        commonRule = commonRule.toUpperCase().replace(mainTableName.toUpperCase() + ".", "mt_alias_sub.");
        return (" select 1 from " + mainTableName + " " + "mt_alias_sub" + " where " + commonRule + " and " + "mt_alias_sub" + ".id=" + "MAIN_TABLE_ALIAS" + ".id ").toUpperCase();
    }

    public static String getCommonRuleConditon(String commonRule, String mainTableName) {
        return commonRule.toUpperCase().replace(mainTableName.toUpperCase() + ".", "MAIN_TABLE_ALIAS.");
    }

    public static String joinRule2Sql(Map.Entry<String, Map<String, String>> refTableMapEntry, List<String> joinRuleList) {
        String mainTableField = refTableMapEntry.getKey();
        String refTableName = refTableMapEntry.getValue().keySet().iterator().next().toUpperCase();
        String refTableAlias = refTableName + "_fks";
        String refTableField = refTableMapEntry.getValue().get(refTableName.toLowerCase());
        for (String joinRule : joinRuleList) {
            if (!joinRule.contains(refTableName)) continue;
            joinRule = joinRule.replace(refTableName, refTableAlias);
            String sql = (" exists ( select 1 from " + refTableName + " " + refTableAlias + " where " + joinRule + " and " + refTableAlias + "." + refTableField + "=" + "MAIN_TABLE_ALIAS" + "." + mainTableField + ")").toUpperCase();
            return sql;
        }
        return null;
    }

    public static String getSimpleCountSql(String sql, String name) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
        stringBuilder.append("select count(");
        stringBuilder.append(name);
        stringBuilder.append(") from (");
        stringBuilder.append(sql);
        stringBuilder.append(") tmp_count");
        return stringBuilder.toString();
    }

    public static void appendSql(BoundSql boundSql, String originalSql) throws NoSuchFieldException, IllegalAccessException {
        Field field = boundSql.getClass().getDeclaredField("sql");
        field.setAccessible(true);
        field.set(boundSql, originalSql);
    }

    static {
        COUNT_TABLE_ALIAS_SET.add("table_count");
        COUNT_TABLE_ALIAS_SET.add("tmp_count");
    }
}

