/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.ds;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.CustomQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.metadata.CustomColumnInfo;
import com.baomidou.mybatisplus.core.metadata.CustomTableInfo;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.huieryun.ds.BaseEoUtil;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.dtyunxi.util.ParamConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

final class BaseMapperHelper {
    private static final Logger log = LoggerFactory.getLogger(BaseMapperHelper.class);
    private static final Map<String, Class<? extends BaseEo>> CLAZZ_GENERIC_TYPES = new ConcurrentHashMap<String, Class<? extends BaseEo>>();
    private static final List<String> KEY_PROPERTIES = Arrays.asList("id", "dr");

    BaseMapperHelper() {
    }

    static Class<? extends BaseEo> getMapperGenericType(Class<? extends BaseMapper> clazz) {
        String clazzName = clazz.getName();
        if (CLAZZ_GENERIC_TYPES.containsKey(clazzName)) {
            return CLAZZ_GENERIC_TYPES.get(clazzName);
        }
        Type[] genTypes = clazz.getGenericInterfaces();
        while (genTypes.length == 0 && !clazz.equals(Object.class)) {
            clazz = clazz.getSuperclass();
            genTypes = clazz.getGenericInterfaces();
        }
        if (genTypes.length == 0) {
            return null;
        }
        for (Type genType : genTypes) {
            ParameterizedType prmType;
            if (!(genType instanceof ParameterizedType) || !BaseMapper.class.isAssignableFrom((Class)(prmType = (ParameterizedType)genType).getRawType())) continue;
            Class typeArgument = (Class)prmType.getActualTypeArguments()[0];
            CLAZZ_GENERIC_TYPES.put(clazzName, typeArgument);
            return typeArgument;
        }
        return null;
    }

    static void parseSqlFilter(AbstractWrapper<?, String, ?> wrapper, List<SqlFilter> sqlFilters) {
        if (CollectionUtils.isEmpty(sqlFilters)) {
            return;
        }
        String entityClassName = wrapper.getEntity().getClass().getName();
        sqlFilters.forEach(sqlFilter -> {
            String property = sqlFilter.getProperty();
            if (StrUtil.isBlank((CharSequence)property)) {
                return;
            }
            if (StrUtil.isBlankIfStr((Object)sqlFilter.getValue()) && sqlFilter.getOperator() != SqlFilter.Operator.isNotNull && sqlFilter.getOperator() != SqlFilter.Operator.isNull) {
                return;
            }
            if ((property = BaseMapperHelper.getColumnByProperty(entityClassName, property)) == null) {
                return;
            }
            block0 : switch (sqlFilter.getOperator()) {
                case eq: {
                    wrapper.eq((Object)property, sqlFilter.getValue());
                    break;
                }
                case ne: {
                    wrapper.ne((Object)property, sqlFilter.getValue());
                    break;
                }
                case gt: {
                    wrapper.gt((Object)property, sqlFilter.getValue());
                    break;
                }
                case lt: {
                    wrapper.lt((Object)property, sqlFilter.getValue());
                    break;
                }
                case ge: {
                    wrapper.ge((Object)property, sqlFilter.getValue());
                    break;
                }
                case le: {
                    wrapper.le((Object)property, sqlFilter.getValue());
                    break;
                }
                case like: {
                    String likeValue = sqlFilter.getValue().toString();
                    int likeFlag = likeValue.startsWith("%") ? 0 : 1;
                    int n = likeValue.endsWith("%") ? 0 : 2;
                    likeValue = likeValue.replaceAll("%", "");
                    switch (likeFlag += n) {
                        case 1: {
                            wrapper.likeRight((Object)property, (Object)likeValue);
                            break block0;
                        }
                        case 2: {
                            wrapper.likeLeft((Object)property, (Object)likeValue);
                            break block0;
                        }
                    }
                    wrapper.like((Object)property, (Object)likeValue);
                    break;
                }
                case in: {
                    Object filterValue = sqlFilter.getValue();
                    Collection<Object> inValues = null;
                    inValues = filterValue instanceof Collection ? (List<Object>)filterValue : (filterValue instanceof String ? (Collection)Stream.of(((String)filterValue).split(",")).map(str -> str.replaceAll("'", "")).collect(Collectors.toList()) : (filterValue instanceof String[] ? (Collection)Stream.of((String[])filterValue).map(str -> str.replaceAll("'", "")).collect(Collectors.toList()) : (filterValue.getClass().isArray() ? Arrays.asList(ParamConverter.objectToArray((Object)filterValue)) : Arrays.asList(filterValue))));
                    wrapper.in((Object)property, (Collection)inValues);
                    break;
                }
                case isNull: {
                    wrapper.isNull((Object)property);
                    break;
                }
                case isNotNull: {
                    wrapper.isNotNull((Object)property);
                }
            }
        });
    }

    static void parseOrderBy(QueryWrapper<?> wrapper, List<SqlOrderBy> sqlOrderBys) {
        if (CollectionUtils.isEmpty(sqlOrderBys)) {
            return;
        }
        String entityClassName = wrapper.getEntity().getClass().getName();
        sqlOrderBys.forEach(sqlOrderBy -> {
            String property = sqlOrderBy.getProperty();
            if (StrUtil.isBlank((CharSequence)property)) {
                return;
            }
            if ((property = BaseMapperHelper.getColumnByProperty(entityClassName, property)) == null) {
                property = sqlOrderBy.getProperty();
            }
            if (sqlOrderBy.getOrder().equals((Object)SortOrder.ASC)) {
                wrapper.orderByAsc((Object)property);
            } else {
                wrapper.orderByDesc((Object)property);
            }
        });
    }

    static <T extends BaseEo> QueryWrapper<T> getQueryWrapper(T obj, String ... tableColumnName) {
        QueryWrapper<T> wrapper = BaseMapperHelper.getQueryWrapper(obj);
        if (ArrayUtils.isNotEmpty((Object[])tableColumnName)) {
            String entityClassName = ((BaseEo)wrapper.getEntity()).getClass().getName();
            wrapper.select(BaseMapperHelper.getSelectColumns(entityClassName, tableColumnName));
        }
        return wrapper;
    }

    static <T extends BaseEo> QueryWrapper<T> getQueryWrapper(T obj) {
        CustomQueryWrapper<T> wrapper = new CustomQueryWrapper<T>(obj);
        BaseMapperHelper.parseSqlFilter(wrapper, obj.getSqlFilters());
        if (StrUtil.isNotBlank((CharSequence)obj.getExtWhere())) {
            wrapper.apply(obj.getExtWhere(), new Object[0]);
        }
        BaseMapperHelper.parseOrderBy(wrapper, obj.getSqlOrderBys());
        return wrapper;
    }

    static <T extends BaseEo> T getEoInstance(Class<T> clazz) {
        BaseEo entity = null;
        try {
            entity = (BaseEo)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("\u521b\u5efa\u5b9e\u4f53\u5931\u8d25\uff01", (Throwable)e);
        }
        return (T)entity;
    }

    private static String getColumnByProperty(String entityClassName, String property) {
        CustomTableInfo tableInfo = BaseEoUtil.tableInfo(entityClassName);
        if (ObjectUtil.isNotNull((Object)tableInfo)) {
            CustomColumnInfo columnInfo = tableInfo.getColumnInfo(property);
            if (ObjectUtil.isNotNull((Object)columnInfo)) {
                return columnInfo.getColumn();
            }
            if (tableInfo.getIdProperty().equals(property)) {
                return tableInfo.getIdColumn();
            }
        }
        return null;
    }

    private static String[] getSelectColumns(String entityClassName, String ... tableColumnName) {
        CustomTableInfo tableInfo = BaseEoUtil.tableInfo(entityClassName);
        return (String[])Stream.of(tableColumnName).map(property -> tableInfo.getColumnInfo((String)property)).filter(t -> t != null).map(p -> p.getColumn()).toArray(String[]::new);
    }

    static <T extends BaseEo> void setUpdateSystemFields(UpdateWrapper<T> wrapper) {
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        wrapper.set((Object)"update_person", (Object)requestUserCode);
        wrapper.setSql(String.format("%s=now()", "update_time"));
    }

    static <T extends BaseEo> void setSelectColumns(QueryWrapper<T> wrapper, String[] tableColumnName) {
        String entityClassName = wrapper.getEntityClass().getName();
        wrapper.select(BaseMapperHelper.getSelectColumns(entityClassName, tableColumnName));
    }

    static <T extends BaseEo> void checkWhereCondition(QueryWrapper<T> wrapper) {
        if (wrapper.isEmptyOfWhere()) {
            wrapper.eq((Object)"dr", (Object)0);
        } else if (BaseMapperHelper.getKeyConditions(wrapper) == null) {
            wrapper.eq((Object)"dr", (Object)0);
        }
    }

    private static <T extends BaseEo> ISqlSegment getKeyConditions(Wrapper<T> wrapper) {
        BaseEo eo;
        if (ObjectUtil.isNotNull((Object)wrapper.getEntity()) && (ObjectUtil.isNotNull((Object)(eo = (BaseEo)wrapper.getEntity()).getId()) || ObjectUtil.isNotNull((Object)eo.getDr()))) {
            return null;
        }
        return wrapper.getExpression().getNormal().stream().filter(sql -> !(sql instanceof SqlKeyword) && KEY_PROPERTIES.contains(sql.getSqlSegment())).findAny().orElse(null);
    }

    static <T extends BaseEo> void checkWhereCondition(UpdateWrapper<T> wrapper) {
        if (wrapper.isEmptyOfWhere()) {
            wrapper.eq((Object)"dr", (Object)0);
        } else if (BaseMapperHelper.getKeyConditions(wrapper) == null) {
            wrapper.eq((Object)"dr", (Object)0);
        }
    }
}

