/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.util;

import com.dtyunxi.annotation.ShardingColumn;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.ds.CamelToUnderline;
import com.dtyunxi.util.ReflectUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DasUtil {
    private static Logger logger = LoggerFactory.getLogger(DasUtil.class);

    public static void validateShardingColunm(BaseEo record, boolean isCreate) {
        if (record == null) {
            return;
        }
        Class<?> tClass = record.getClass();
        ShardingColumn annotation = tClass.getAnnotation(ShardingColumn.class);
        if (annotation != null) {
            ShardingColumn shardingColumn = annotation;
            String name = shardingColumn.name();
            String propertyName = CamelToUnderline.underlineToCamel((String)name);
            Object objectValue = null;
            try {
                Field field = ReflectUtil.getField(tClass, (String)propertyName);
                field.setAccessible(true);
                objectValue = field.get(record);
                if (!isCreate) {
                    field.set(record, null);
                }
            }
            catch (Exception e) {
                logger.error("\u8bbe\u7f6e\u62c6\u5206\u952e\u503c\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u62c6\u5206\u952e\u5c5e\u6027:" + propertyName);
            }
            if (objectValue == null || objectValue instanceof String && StringUtils.isBlank((CharSequence)((String)objectValue))) {
                throw new RuntimeException("\u5b9e\u4f53\u5bf9\u5e94\u62c6\u5206\u952e\u5c5e\u6027 " + propertyName + " \u7684\u5c5e\u6027\u503c\u4e3a\u7a7a! ");
            }
            if (!isCreate) {
                List filters = record.getSqlFilters();
                if (CollectionUtils.isEmpty((Collection)filters)) {
                    filters = Lists.newArrayList();
                }
                SqlFilter filter = new SqlFilter(propertyName, SqlFilter.Operator.eq, objectValue);
                filters.add(filter);
                DasUtil.addIdFilter(record, filters);
                record.setSqlFilters(filters);
            }
        }
    }

    private static void addIdFilter(BaseEo record, List<SqlFilter> filters) {
        if (CollectionUtils.isNotEmpty(filters) && record != null && record.getId() != null) {
            HashMap filterMap = Maps.newHashMap();
            for (SqlFilter filter : filters) {
                filterMap.put(filter.getProperty(), filter);
            }
            if (!filterMap.containsKey("id")) {
                SqlFilter idFilter = new SqlFilter("id", SqlFilter.Operator.eq, (Object)record.getId());
                filters.add(idFilter);
            }
        }
    }
}

