/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.dao.mybatis.config;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.core.metadata.CustomSqlInjector;
import com.baomidou.mybatisplus.core.metadata.CustomTenantLineInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.dtyunxi.huieryun.dao.mybatis.config.ConditionalOnDaoMybatis;
import com.dtyunxi.huieryun.dao.mybatis.support.mybatis.MyIdentifierGenerator;
import com.dtyunxi.huieryun.dao.mybatis.support.mybatis.MyMetaObjectHandler;
import com.dtyunxi.huieryun.dao.mybatis.support.mybatis.MyTenantHandler;
import com.dtyunxi.huieryun.plugin.ParameterInterceptor;
import com.dtyunxi.huieryun.plugin.QueryLimitInterceptor;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInterceptor;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@ConditionalOnDaoMybatis
@PropertySource(value={"classpath:config/mybatis-plus.properties"})
@EnableConfigurationProperties(value={IgnoreTanantTableConfig.class})
@ConditionalOnClass(value={MybatisPlusAutoConfiguration.class})
public class CustomMybatisPlusAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CustomMybatisPlusAutoConfiguration.class);
    private final IgnoreTanantTableConfig ignoreTanantTableConfig;
    @Value(value="${dtyunxi.cube.mybatis.ignore.withoutColumnAnnotationField:true}")
    private boolean ignoreWithoutColumnAnnotationField = true;

    @Bean
    public PageInterceptor pageInterceptor() {
        return new PageInterceptor();
    }

    public CustomMybatisPlusAutoConfiguration(IgnoreTanantTableConfig ignoreTanantTableConfig) {
        this.ignoreTanantTableConfig = ignoreTanantTableConfig;
    }

    @Bean
    public CustomSqlInjector jpaAnnotationSqlInjector() {
        return new CustomSqlInjector(this.ignoreWithoutColumnAnnotationField);
    }

    @Bean
    @ConditionalOnProperty(name={"dtyunxi.cube.mybatis.query.limit.enabled"}, havingValue="true")
    public QueryLimitInterceptor queryLimitInterceptor() {
        return new QueryLimitInterceptor();
    }

    @Bean
    @ConditionalOnProperty(name={"cube.meta.ext.enabled"}, havingValue="true")
    public ParameterInterceptor paramInterceptor() {
        return new ParameterInterceptor();
    }

    @Bean
    public MyMetaObjectHandler myMetaObjectHandler() {
        return new MyMetaObjectHandler();
    }

    @Bean
    public MyIdentifierGenerator myIdentifierGenerator() {
        return new MyIdentifierGenerator();
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        if (log.isInfoEnabled()) {
            log.info("\u81ea\u5b9a\u4e49\u62e6\u622a\u63d2\u4ef6,\u5ffd\u7565\u8868={}", (Object)JacksonUtil.toJson(this.ignoreTanantTableConfig.getTables()));
        }
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (!this.ignoreTanantTableConfig.queryLimit) {
            interceptor.addInnerInterceptor((InnerInterceptor)new CustomTenantLineInnerInterceptor(new MyTenantHandler(this.ignoreTanantTableConfig.getTables())));
        }
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor());
        return interceptor;
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return configuration -> configuration.setUseDeprecatedExecutor(false);
    }

    @Bean
    public DatabaseIdProvider databaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties p = new Properties();
        p.setProperty("Oracle", "oracle");
        p.setProperty("MySQL", "mysql");
        p.setProperty("PostgreSQL", "postgresql");
        p.setProperty("DB2", "db2");
        p.setProperty("SQL Server", "sqlserver");
        databaseIdProvider.setProperties(p);
        return databaseIdProvider;
    }

    @ConfigurationProperties(prefix="dtyunxi.cube.mybatis.ignore.tenant")
    public static class IgnoreTanantTableConfig {
        private List<String> tables;
        private boolean queryLimit = true;

        public List<String> getTables() {
            return this.tables;
        }

        public boolean isQueryLimit() {
            return this.queryLimit;
        }

        public void setTables(List<String> tables) {
            this.tables = tables;
        }

        public void setQueryLimit(boolean queryLimit) {
            this.queryLimit = queryLimit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IgnoreTanantTableConfig)) {
                return false;
            }
            IgnoreTanantTableConfig other = (IgnoreTanantTableConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isQueryLimit() != other.isQueryLimit()) {
                return false;
            }
            List<String> this$tables = this.getTables();
            List<String> other$tables = other.getTables();
            return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IgnoreTanantTableConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isQueryLimit() ? 79 : 97);
            List<String> $tables = this.getTables();
            result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
            return result;
        }

        public String toString() {
            return "CustomMybatisPlusAutoConfiguration.IgnoreTanantTableConfig(tables=" + this.getTables() + ", queryLimit=" + this.isQueryLimit() + ")";
        }
    }
}

