/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.ds;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.CustomQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.dtyunxi.annotation.DeprecatedDescForJDK8;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.huieryun.ds.BaseMapperHelper;
import com.dtyunxi.huieryun.type.SqlEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.session.SqlSession;

public interface BaseMapper<T extends BaseEo>
extends com.baomidou.mybatisplus.core.mapper.BaseMapper<T> {
    default public Class<? extends BaseMapper> getMapperClass() {
        Class<?> clazz = this.getClass();
        if (clazz.getName().startsWith("com.sun.proxy.$Proxy")) {
            clazz = clazz.getInterfaces()[0];
        }
        return clazz;
    }

    default public Class<T> currentModelClass() {
        return BaseMapperHelper.getMapperGenericType(this.getMapperClass());
    }

    default public SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(this.currentModelClass());
    }

    default public String sqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.getSqlStatement(this.getMapperClass(), (SqlMethod)sqlMethod);
    }

    default public String sqlStatement(String sqlMethod) {
        Class<BaseMapper> mapper = this.getMapperClass();
        return mapper.getName() + "." + sqlMethod;
    }

    default public int insertBatch(List<T> objList) {
        if (CollectionUtils.isEmpty(objList)) {
            throw new IllegalArgumentException("\u63d2\u5165\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        int i = 0;
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int batchSize = 1000;
            String sqlStatement = this.sqlStatement(SqlMethod.INSERT_ONE);
            for (BaseEo entity : objList) {
                batchSqlSession.insert(sqlStatement, (Object)entity);
                if (i >= 1 && i % 1000 == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new RuntimeException("\u6279\u91cf\u63d2\u5165\u5931\u8d25\uff01", e);
        }
        return i;
    }

    default public int updateBatch(List<T> objList) {
        if (CollectionUtils.isEmpty(objList)) {
            throw new IllegalArgumentException("\u66f4\u65b0\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        int i = 0;
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int batchSize = 1000;
            String sqlStatement = this.sqlStatement("batchUpdateById");
            for (BaseEo entity : objList) {
                entity.setUpdatePerson(requestUserCode);
                batchSqlSession.update(sqlStatement, (Object)entity);
                if (i >= 1 && i % 1000 == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new RuntimeException("\u6279\u91cf\u66f4\u65b0\u5931\u8d25\uff01", e);
        }
        return i;
    }

    default public int updateById(@Param(value="et") T entity) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)entity.getId());
        BaseMapperHelper.setUpdateSystemFields(updateWrapper);
        return this.update(entity, (Wrapper)updateWrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="updateAll(obj, updateWrapper)")
    default public int update(T obj) {
        UpdateWrapper updateWrapper = new UpdateWrapper(obj);
        BaseMapperHelper.parseSqlFilter(updateWrapper, obj.getSqlFilters());
        if (obj.getId() != null) {
            updateWrapper.eq((Object)"id", (Object)obj.getId());
        }
        updateWrapper.setEntity(null);
        BaseMapperHelper.setUpdateSystemFields(updateWrapper);
        BaseMapperHelper.checkWhereCondition(updateWrapper);
        return this.updateAll(obj, (Wrapper<T>)updateWrapper);
    }

    public int updateAll(@Param(value="et") T var1, @Param(value="ew") Wrapper<T> var2);

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="update(obj, updateWrapper)")
    default public int updateSelective(T obj) {
        UpdateWrapper updateWrapper = new UpdateWrapper(obj);
        BaseMapperHelper.parseSqlFilter(updateWrapper, obj.getSqlFilters());
        if (obj.getId() != null) {
            updateWrapper.eq((Object)"id", (Object)obj.getId());
        }
        updateWrapper.setEntity(null);
        BaseMapperHelper.setUpdateSystemFields(updateWrapper);
        BaseMapperHelper.checkWhereCondition(updateWrapper);
        return this.update(obj, (Wrapper)updateWrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="update(obj, updateWrapper)")
    default public int updateSelectiveSqlFilter(T obj) {
        UpdateWrapper updateWrapper = new UpdateWrapper(obj);
        BaseMapperHelper.parseSqlFilter(updateWrapper, obj.getSqlFilters());
        updateWrapper.setEntity(null);
        BaseMapperHelper.setUpdateSystemFields(updateWrapper);
        if (updateWrapper.isEmptyOfWhere()) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        BaseMapperHelper.checkWhereCondition(updateWrapper);
        return this.update(obj, (Wrapper)updateWrapper);
    }

    public int logicDelete(@Param(value="ew") Wrapper<T> var1);

    public int physicallyDeleteById(Serializable var1);

    public int physicallyDelete(@Param(value="ew") Wrapper<T> var1);

    default public int deleteById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"id", (Object)id);
        wrapper.set((Object)"dr", (Object)1);
        BaseMapperHelper.setUpdateSystemFields(wrapper);
        int result = this.logicDelete((Wrapper<T>)wrapper);
        if (result == 0) {
            return 0;
        }
        return this.physicallyDeleteById(id);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="deleteById(id)")
    default public int deleteById(Class<T> aClass, Long id) {
        return this.deleteById(id);
    }

    default public int deleteLogicById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"id", (Object)id);
        wrapper.set((Object)"dr", (Object)1);
        BaseMapperHelper.setUpdateSystemFields(wrapper);
        return this.logicDelete((Wrapper<T>)wrapper);
    }

    default public int deleteLogicByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.in((Object)"id", ids);
        wrapper.set((Object)"dr", (Object)1);
        BaseMapperHelper.setUpdateSystemFields(wrapper);
        return this.logicDelete((Wrapper<T>)wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="deleteLogicById(id)")
    default public int deleteLogicById(Class<T> aClass, Long id) {
        return this.deleteLogicById(id);
    }

    default public int deleteBatchIds(Long[] ids) {
        if (ObjectUtil.isAllEmpty((Object[])ids)) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.in((Object)"id", (Object[])ids);
        wrapper.set((Object)"dr", (Object)2);
        BaseMapperHelper.setUpdateSystemFields(wrapper);
        int result = this.logicDelete((Wrapper<T>)wrapper);
        if (result == 0) {
            return 0;
        }
        return this.physicallyDelete((Wrapper<T>)wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="deleteBatchIds(ids)")
    default public int deleteBatchIds(Class<T> aClass, Long[] ids) {
        return this.deleteBatchIds(ids);
    }

    default public int deleteLogicBatchIds(Long[] ids) {
        if (ObjectUtil.isAllEmpty((Object[])ids)) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.in((Object)"id", (Object[])ids);
        wrapper.set((Object)"dr", (Object)1);
        BaseMapperHelper.setUpdateSystemFields(wrapper);
        return this.logicDelete((Wrapper<T>)wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="deleteLogicBatchIds(ids)")
    default public int deleteLogicBatchIds(Class<T> aClass, Long[] ids) {
        return this.deleteLogicBatchIds(ids);
    }

    default public int delete(T obj) {
        UpdateWrapper wrapper = new UpdateWrapper(obj);
        BaseMapperHelper.parseSqlFilter(wrapper, obj.getSqlFilters());
        if (wrapper.isEmptyOfWhere()) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        wrapper.set((Object)"dr", (Object)2);
        BaseMapperHelper.setUpdateSystemFields(wrapper);
        int result = this.logicDelete((Wrapper<T>)wrapper);
        if (result == 0) {
            return 0;
        }
        return this.physicallyDelete((Wrapper<T>)wrapper);
    }

    @Deprecated
    default public int deleteLogic(T obj) {
        UpdateWrapper wrapper = new UpdateWrapper(obj);
        BaseMapperHelper.parseSqlFilter(wrapper, obj.getSqlFilters());
        if (wrapper.isEmptyOfWhere()) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        wrapper.set((Object)"dr", (Object)1);
        BaseMapperHelper.setUpdateSystemFields(wrapper);
        BaseMapperHelper.checkWhereCondition(wrapper);
        return this.logicDelete((Wrapper<T>)wrapper);
    }

    default public T findById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        CustomQueryWrapper wrapper = new CustomQueryWrapper();
        wrapper.eq("id", id);
        wrapper.eq("dr", 0);
        return (T)((BaseEo)this.selectOne((Wrapper)wrapper));
    }

    default public T findById(Class<T> aClass, Long id) {
        return this.findById(id);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectList(wrapper)")
    default public List<T> findByIdsDr(Class<T> aClass, Long[] ids, Boolean containsDr) {
        if (ObjectUtil.isAllEmpty((Object[])ids)) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        CustomQueryWrapper wrapper = new CustomQueryWrapper();
        wrapper.in("id", ids);
        if (!containsDr.booleanValue()) {
            wrapper.eq("dr", 0);
        }
        return this.selectList((Wrapper)wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectOne(wrapper)")
    default public T findColumnById(Class<T> aClass, Long id, String ... tableColumnName) {
        if (id == null) {
            throw new IllegalArgumentException("The where condition is missing.");
        }
        QueryWrapper wrapper = (QueryWrapper)new CustomQueryWrapper<Class<T>>(aClass).eq("id", id);
        wrapper.eq((Object)"dr", (Object)0);
        BaseMapperHelper.setSelectColumns(wrapper, tableColumnName);
        return (T)((BaseEo)this.selectOne((Wrapper)wrapper));
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectOne(wrapper)")
    default public T find(T obj) {
        QueryWrapper<T> wrapper = BaseMapperHelper.getQueryWrapper(obj);
        BaseMapperHelper.checkWhereCondition(wrapper);
        Page page = new Page(0L, 1L, false);
        page = this.selectPage((IPage)page, (Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)page.getRecords())) {
            return null;
        }
        return (T)((BaseEo)page.getRecords().get(0));
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectList(wrapper)")
    default public List<Long> findIdBySqlFilter(T obj) {
        QueryWrapper<T> wrapper = BaseMapperHelper.getQueryWrapper(obj);
        BaseMapperHelper.checkWhereCondition(wrapper);
        wrapper.select(new String[]{"id"});
        List list = this.selectList((Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return list.stream().map(BaseEo::getId).collect(Collectors.toList());
        }
        return new ArrayList<Long>(0);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectOne(wrapper)")
    default public T findColumn(@Param(value="obj") T obj, String ... tableColumnName) {
        QueryWrapper<T> wrapper = BaseMapperHelper.getQueryWrapper(obj, tableColumnName);
        BaseMapperHelper.checkWhereCondition(wrapper);
        Page page = new Page(0L, 1L, false);
        page = this.selectPage((IPage)page, (Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)page.getRecords())) {
            return null;
        }
        return (T)((BaseEo)page.getRecords().get(0));
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectList(wrapper)")
    default public List<T> findList(T obj) {
        return this.findListColumn(obj, new String[0]);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectList(wrapper)")
    default public List<T> findListColumn(@Param(value="obj") T obj, String ... tableColumnName) {
        QueryWrapper<T> wrapper = BaseMapperHelper.getQueryWrapper(obj, tableColumnName);
        BaseMapperHelper.checkWhereCondition(wrapper);
        return this.selectList((Wrapper)wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findPageListWithMySQLDialect(@Param(value="obj") T obj, Integer currentPage, Integer pageSize, String ... tableColumnName) {
        return this.findPageListWithColumns(obj, currentPage, pageSize, tableColumnName);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findPageList(@Param(value="obj") T obj, Integer currentPage, Integer pageSize) {
        return this.findPageListWithColumns(obj, currentPage, pageSize, new String[0]);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public IPage<T> findPage(@Param(value="obj") T obj, Integer currentPage, Integer pageSize) {
        QueryWrapper<T> wrapper = BaseMapperHelper.getQueryWrapper(obj);
        return this.findPage(currentPage, pageSize, wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findPageList(@Param(value="obj") T obj, Integer currentPage, Integer pageSize, SqlEnum sqlEnum) {
        return this.findPageList(obj, currentPage, pageSize);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findPageListWithColumns(@Param(value="obj") T obj, Integer currentPage, Integer pageSize, String ... tableColumnName) {
        QueryWrapper<T> wrapper = BaseMapperHelper.getQueryWrapper(obj, tableColumnName);
        return this.findWithPage(currentPage, pageSize, wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findPageListWithColumns(@Param(value="obj") T obj, Integer currentPage, Integer pageSize, SqlEnum sqlEnum, String ... tableColumnName) {
        return this.findPageListWithColumns(obj, currentPage, pageSize, tableColumnName);
    }

    default public List<T> findAll() {
        CustomQueryWrapper wrapper = new CustomQueryWrapper();
        wrapper.eq("dr", 0);
        return this.selectList((Wrapper)wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="findAll()")
    default public List<T> findAll(Class<T> aClass) {
        return this.findAll();
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectList(wrapper)")
    default public List<T> findAllWithColumns(String ... tableColumnName) {
        CustomQueryWrapper<Class<T>> wrapper = new CustomQueryWrapper<Class<T>>(this.currentModelClass());
        wrapper.eq("dr", 0);
        BaseMapperHelper.setSelectColumns(wrapper, tableColumnName);
        return this.selectList((Wrapper)wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectList(wrapper)")
    default public List<T> findAllWithColumns(Class<T> aClass, String ... tableColumnName) {
        return this.findAllWithColumns(tableColumnName);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectList(wrapper)")
    default public List<T> findAllWithOrderBy(List<SqlOrderBy> sqlOrderBys, String ... tableColumnName) {
        CustomQueryWrapper<Class<T>> wrapper = new CustomQueryWrapper<Class<T>>(this.currentModelClass());
        BaseMapperHelper.setSelectColumns(wrapper, tableColumnName);
        BaseMapperHelper.parseOrderBy(wrapper, sqlOrderBys);
        wrapper.eq("dr", 0);
        return this.selectList((Wrapper)wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectList(wrapper)")
    default public List<T> findAllWithOrderBy(Class<T> aClass, List<SqlOrderBy> sqlOrderBys, String ... tableColumnName) {
        return this.findAllWithOrderBy(sqlOrderBys, tableColumnName);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findAllWithPage(Integer currentPage, Integer pageSize) {
        CustomQueryWrapper wrapper = new CustomQueryWrapper();
        wrapper.eq("dr", 0);
        return this.findWithPage(currentPage, pageSize, wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findAllWithPage(Class<T> aClass, Integer currentPage, Integer pageSize) {
        CustomQueryWrapper wrapper = new CustomQueryWrapper();
        wrapper.eq("dr", 0);
        return this.findWithPage(currentPage, pageSize, wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findAllWithPage(Integer currentPage, Integer pageSize, String ... tableColumnName) {
        CustomQueryWrapper<Class<T>> wrapper = new CustomQueryWrapper<Class<T>>(this.currentModelClass());
        BaseMapperHelper.setSelectColumns(wrapper, tableColumnName);
        wrapper.eq("dr", 0);
        return this.findWithPage(currentPage, pageSize, wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findWithPage(Integer currentPage, Integer pageSize, QueryWrapper<T> wrapper) {
        Page page = new Page((long)((Integer)ObjectUtil.defaultIfNull((Object)currentPage, (Object)1)).intValue(), (long)((Integer)ObjectUtil.defaultIfNull((Object)pageSize, (Object)10)).intValue(), false);
        BaseMapperHelper.checkWhereCondition(wrapper);
        IPage result = this.selectPage((IPage)page, (Wrapper)wrapper);
        return result.getRecords();
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public IPage<T> findPage(Integer currentPage, Integer pageSize, QueryWrapper<T> wrapper) {
        Page page = new Page((long)((Integer)ObjectUtil.defaultIfNull((Object)currentPage, (Object)1)).intValue(), (long)((Integer)ObjectUtil.defaultIfNull((Object)pageSize, (Object)10)).intValue());
        BaseMapperHelper.checkWhereCondition(wrapper);
        IPage result = this.selectPage((IPage)page, (Wrapper)wrapper);
        return result;
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findAllWithPage(Class<T> aClass, Integer currentPage, Integer pageSize, String ... tableColumnName) {
        return this.findAllWithPage(currentPage, pageSize, tableColumnName);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findAllWithPageAndOrderBy(@Nullable Class<T> aClass, List<SqlOrderBy> sqlOrderBys, Integer currentPage, Integer pageSize, String ... tableColumnName) {
        return this.findAllWithPageAndOrderBy(sqlOrderBys, currentPage, pageSize, tableColumnName);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findAllWithPageAndSQLDialect(@Nullable Class<T> aClass, Integer currentPage, Integer pageSize, SqlEnum sqlEnum, String ... tableColumnName) {
        return this.findAllWithPage(currentPage, pageSize, tableColumnName);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findAllWithPageAndOrderBy(List<SqlOrderBy> sqlOrderBys, Integer currentPage, Integer pageSize, String ... tableColumnName) {
        CustomQueryWrapper<Class<T>> wrapper = new CustomQueryWrapper<Class<T>>(this.currentModelClass());
        BaseMapperHelper.parseOrderBy(wrapper, sqlOrderBys);
        BaseMapperHelper.setSelectColumns(wrapper, tableColumnName);
        wrapper.eq("dr", 0);
        return this.findWithPage(currentPage, pageSize, wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectPage(page, wrapper)")
    default public List<T> findAllWithPageAndSQLDialectAndOrderBy(@Nullable Class<T> aClass, List<SqlOrderBy> sqlOrderBys, Integer currentPage, Integer pageSize, @Nullable SqlEnum sqlEnum, String ... tableColumnName) {
        return this.findAllWithPageAndOrderBy(sqlOrderBys, currentPage, pageSize, tableColumnName);
    }

    default public int count() {
        CustomQueryWrapper wrapper = new CustomQueryWrapper();
        wrapper.eq("dr", 0);
        return this.selectCount((Wrapper)wrapper);
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectCount(wrapper)")
    default public int count(@Nullable Class<T> aClass) {
        return this.count();
    }

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="selectCount(wrapper)")
    default public int countCondition(T obj) {
        CustomQueryWrapper<T> wrapper = new CustomQueryWrapper<T>(obj);
        BaseMapperHelper.parseSqlFilter(wrapper, obj.getSqlFilters());
        BaseMapperHelper.checkWhereCondition(wrapper);
        return this.selectCount((Wrapper)wrapper);
    }
}

