/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.ds;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.BaseEoUtil;
import com.dtyunxi.eo.CamelToUnderline;
import com.dtyunxi.huieryun.ds.IdGenrator;
import com.dtyunxi.huieryun.type.SqlEnum;
import com.dtyunxi.util.SqlUtil;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;

public class SqlTemplate<T extends BaseEo> {
    public String insert(T obj) {
        SQL sql = new SQL();
        sql.INSERT_INTO(obj.tableName());
        StringBuilder sb = new StringBuilder();
        String value = this.replaceInsertCreatePerson(obj.returnInsertColumnsDef(), obj.getCreatePerson());
        value = this.replaceInsertTenantId(value, obj.getTenantId());
        long id = this.getId();
        sb.append(id).append(",").append(value);
        sql.VALUES(obj.returnInsertColumnsName(), String.valueOf(sb));
        obj.setId(Long.valueOf(id));
        return sql.toString();
    }

    private long getId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = BaseEoUtil.getWorkerId();
        return IdGenrator.nextId(workerId, tenantCode);
    }

    public String insertBatch(Map<String, List<T>> params) {
        List<T> objList = params.get("objList");
        String sql = "sql error";
        if (objList == null || objList.isEmpty()) {
            return sql;
        }
        BaseEo obj = (BaseEo)objList.get(0);
        String tableName = obj.tableName();
        if (tableName == null) {
            return sql;
        }
        StringBuffer sb = new StringBuffer("insert into ").append(tableName).append("(" + obj.returnInsertColumnsNameBatch() + ")").append(" values ");
        String insertValueColumns = this.replaceInsertCreatePerson(obj.returnInsertColumnsDefBatch(), obj.getCreatePerson());
        insertValueColumns = this.replaceInsertTenantId(insertValueColumns, obj.getTenantId());
        MessageFormat mf = new MessageFormat(insertValueColumns);
        for (int i = 0; i < objList.size(); ++i) {
            long id = this.getId();
            sb.append("(").append(id).append(",");
            sb.append(mf.format(new Object[]{String.valueOf(i)}));
            if (i < objList.size() - 1) {
                sb.append(",");
            }
            ((BaseEo)objList.get(i)).setId(Long.valueOf(id));
        }
        return sb.toString();
    }

    private String replaceInsertTenantId(String insertValue, Long tenantId) {
        if (tenantId == null) {
            tenantId = 1L;
        }
        return insertValue.replaceAll("#tenantId", String.valueOf(tenantId));
    }

    private String replaceInsertCreatePerson(String insertValue, String createPerson) {
        if (StringUtils.isEmpty((CharSequence)createPerson)) {
            createPerson = "";
        }
        return insertValue.replaceAll("#createPerson", createPerson);
    }

    public String update(T obj) {
        return this.getUpdateSql(obj, 0);
    }

    public String updateSelective(T obj) {
        return this.getUpdateSql(obj, 1);
    }

    private String getUpdateSql(T obj, Integer flag) {
        String returnUpdateSet = null;
        returnUpdateSet = flag == 0 ? obj.returnUpdateSet() : obj.returnUpdateSetNotNull();
        String idname = obj.idName();
        SQL sql = new SQL();
        sql.UPDATE(obj.tableName());
        sql.SET(returnUpdateSet);
        sql.WHERE(this.joinExtWhere(obj, idname + "= #{" + idname + "}"));
        return sql.toString();
    }

    public String updateSelectiveSqlFilter(T obj) {
        SQL sql = new SQL();
        sql.UPDATE(obj.tableName());
        sql.SET(obj.returnUpdateSetNotNull());
        String where = obj.returnUpdateWhereColumnNames();
        if ("".equals(where)) {
            return null;
        }
        sql.WHERE(this.joinExtWhere(obj, where));
        return sql.toString();
    }

    public String delete(T obj) {
        return this.deleteLogic(obj, false);
    }

    public String deleteLogic(T obj, Boolean isLogicDel) {
        String where = this.getWhere(obj);
        if ("".equals(where)) {
            return null;
        }
        StringBuilder sqlStr = new StringBuilder();
        int dr = isLogicDel == null || isLogicDel != false ? 1 : 2;
        String tableName = obj.tableName();
        SQL sql = new SQL();
        sql.UPDATE(tableName);
        sql.SET(this.getUpdateCreatePersonDr(dr, obj.getUpdatePerson()));
        sql.WHERE(this.joinExtWhere(obj, where));
        sqlStr.append(sql.toString());
        if (isLogicDel != null && !isLogicDel.booleanValue()) {
            sql = new SQL();
            sql.DELETE_FROM(tableName);
            sql.WHERE(this.joinExtWhere(obj, where.replace("dr=0", "dr=" + dr)));
            sqlStr.append(";").append(sql.toString()).append(";");
        }
        return sqlStr.toString();
    }

    public String deleteLogicById(Class<T> aClass, Long id, Boolean isLogicDel) {
        Long[] ids = new Long[]{id};
        return this.deleteLogicBatchIds(aClass, ids, isLogicDel);
    }

    public String deleteLogicByIdWithCriteria(Class<T> aClass, Long id, Boolean isLogicDel, String extWhere) {
        Long[] ids = new Long[]{id};
        return this.deleteLogicBatchIdsWithCriteria(aClass, ids, isLogicDel, extWhere);
    }

    public String deleteById(Class<T> aClass, Long id) {
        Long[] ids = new Long[]{id};
        return this.deleteLogicBatchIds(aClass, ids, false);
    }

    public String deleteByIdWithCriteria(Class<T> aClass, Long id, String where) {
        Long[] ids = new Long[]{id};
        return this.deleteLogicBatchIdsWithCriteria(aClass, ids, false, where);
    }

    public String deleteBatch(Class<T> aClass, Long[] ids) {
        return this.deleteLogicBatchIds(aClass, ids, false);
    }

    public String deleteBatchWithCriteria(Class<T> aClass, Long[] ids, String extWhere) {
        return this.deleteLogicBatchIdsWithCriteria(aClass, ids, false, extWhere);
    }

    public String deleteLogicBatchIds(Class<T> aClass, Long[] ids, Boolean isLogicDel) {
        return this.deleteLogicBatchIdsWithCriteria(aClass, ids, isLogicDel, null);
    }

    public String deleteLogicBatchIdsWithCriteria(Class<T> aClass, Long[] ids, Boolean isLogicDel, String extWhere) {
        if (ids == null || ids.length < 1) {
            return null;
        }
        String idStr = StringUtils.join((Object[])ids, (String)",");
        int dr = isLogicDel == null || isLogicDel != false ? 1 : 2;
        String tableName = BaseEoUtil.tableName(aClass);
        StringBuilder sqlStr = new StringBuilder();
        SQL sql = new SQL();
        sql.UPDATE(tableName);
        sql.SET(this.getUpdateCreatePersonDr(dr, null));
        String where = "id in (" + idStr + ") and dr = 0";
        sql.WHERE(this.joinExtWhere(extWhere, where));
        sqlStr.append(sql.toString()).append(";");
        if (isLogicDel != null && !isLogicDel.booleanValue()) {
            sql = new SQL();
            sql.DELETE_FROM(tableName);
            sql.WHERE(this.joinExtWhere(extWhere, "id in (" + idStr + ") and dr = 2"));
            sqlStr.append(sql.toString()).append(";");
        }
        return sqlStr.toString();
    }

    private String getUpdateCreatePersonDr(int dr, String updatePerson) {
        StringBuilder sb = new StringBuilder();
        sb.append("dr=").append(dr).append(",update_time=now()");
        String reqUupdatePerson = ServiceContext.getContext().getRequestUserCode();
        if (StringUtils.isEmpty((CharSequence)reqUupdatePerson) && StringUtils.isNotEmpty((CharSequence)updatePerson)) {
            reqUupdatePerson = updatePerson;
        }
        if (StringUtils.isNotEmpty((CharSequence)reqUupdatePerson)) {
            sb.append(",update_person='").append(reqUupdatePerson).append("'");
        }
        return sb.toString();
    }

    public String find(T obj) {
        return this.findColumn(obj, new String[0]);
    }

    public String findColumn(T obj, String ... tableColumnName) {
        SQL sql = new SQL();
        sql.SELECT(this.getSelectColumnNames(obj, tableColumnName));
        sql.FROM(obj.tableName());
        String where = this.getWhere(obj);
        if (!"".equals(where)) {
            sql.WHERE(this.joinExtWhere(obj, where));
        } else {
            sql.WHERE(this.joinExtWhere(obj, "dr = 0"));
        }
        return sql.toString();
    }

    public String findIdBySqlFilter(T obj) {
        SQL sql = new SQL();
        sql.SELECT("id");
        sql.FROM(obj.tableName());
        String where = obj.returnUpdateWhereColumnNames();
        if (!"".equals(where)) {
            sql.WHERE(this.joinExtWhere(obj, where));
            return sql.toString();
        }
        return null;
    }

    public String findList(T obj) {
        return this.findListColumn(obj, new String[0]);
    }

    public String findListColumn(T obj, String ... tableColumnName) {
        SQL sql = new SQL();
        sql.SELECT(this.getSelectColumnNames(obj, tableColumnName));
        sql.FROM(obj.tableName());
        String where = this.getWhere(obj);
        if (!"".equals(where)) {
            sql.WHERE(this.joinExtWhere(obj, where));
        } else {
            sql.WHERE(this.joinExtWhere(obj, "dr = 0"));
        }
        String orderBy = obj.resultOrderBy();
        if (!"".equals(orderBy)) {
            sql.ORDER_BY(orderBy);
        }
        return sql.toString();
    }

    public String distinctFindListColumn(Class<T> aClass, Map<String, Object> queryParams, String ... tableColumnName) {
        SQL sql = new SQL();
        sql.SELECT(" DISTINCT " + StringUtils.join((Object[])tableColumnName, (String)",").toLowerCase());
        sql.FROM(BaseEoUtil.tableName(aClass));
        String where = " dr=0 ";
        String andWhere = this.getAndWhere(queryParams);
        if (StringUtils.isNotEmpty((CharSequence)andWhere)) {
            sql.WHERE(where + andWhere);
        }
        return sql.toString();
    }

    private String getAndWhere(Map<String, Object> queryParams) {
        if (queryParams != null) {
            StringBuilder andWhereSql = new StringBuilder();
            for (Map.Entry<String, Object> map : queryParams.entrySet()) {
                andWhereSql.append("AND ").append(map.getKey()).append("=").append("'").append(map.getValue()).append("'");
            }
            return andWhereSql.toString();
        }
        return null;
    }

    public String findPageList(T obj, Integer currentPage, Integer pageSize, SqlEnum sqlEnum) {
        currentPage = currentPage != null ? currentPage : 1;
        pageSize = pageSize != null ? pageSize : 10;
        int pageNo = (currentPage - 1) * pageSize;
        StringBuilder strBuilder = new StringBuilder();
        boolean bool = false;
        if (sqlEnum != null && sqlEnum.equals((Object)SqlEnum.postgreSql)) {
            strBuilder.append(" limit ").append(pageSize).append(" offset ").append(pageNo);
            bool = true;
        }
        if (!bool) {
            strBuilder.append(" limit ").append(pageNo).append(",").append(pageSize);
        }
        String sql = this.findList(obj);
        return sql + strBuilder.toString();
    }

    public String findById(Class<T> aClass, Long id) {
        return this.findColumnById(aClass, id, new String[0]);
    }

    public String findByIdWithCriteria(Class<T> aClass, Long id, String extWhere) {
        return this.findColumnByIdWithCriteria(aClass, id, extWhere, new String[0]);
    }

    public String findByIdsDr(Class<T> aClass, Long[] ids, Boolean containsDr) {
        return this.findColumnByIdsDr(aClass, ids, containsDr, new String[0]);
    }

    public String findByIdsDrWithCriteria(Class<T> aClass, Long[] ids, Boolean containsDr, String extWhere) {
        return this.findColumnByIdsDrWithCriteria(aClass, ids, containsDr, extWhere, new String[0]);
    }

    public String findColumnByIdsDr(Class<T> aClass, Long[] ids, Boolean containsDr, String ... tableColumnName) {
        return this.findColumnByIdsDrWithCriteria(aClass, ids, containsDr, null, tableColumnName);
    }

    public String findColumnByIdsDrWithCriteria(Class<T> aClass, Long[] ids, Boolean containsDr, String extWhere, String ... tableColumnName) {
        String selectColumnName = null;
        if (tableColumnName != null && tableColumnName.length > 0) {
            selectColumnName = StringUtils.join((Object[])tableColumnName, (String)",").toLowerCase();
            if (!SqlUtil.isSpiteParams((String)selectColumnName)) {
                selectColumnName = this.selectColumnsAlias(aClass);
            }
        } else {
            selectColumnName = this.selectColumnsAlias(aClass);
        }
        SQL sql = new SQL();
        sql.SELECT(selectColumnName);
        sql.FROM(BaseEoUtil.tableName(aClass));
        String idname = BaseEoUtil.idName(aClass);
        String where = null;
        where = ids.length == 1 ? idname + " = " + ids[0] : idname + " in (" + StringUtils.join((Object[])ids, (String)",") + ")";
        if (!containsDr.booleanValue()) {
            where = where + " and dr=0";
        }
        sql.WHERE(this.joinExtWhere(extWhere, where));
        return sql.toString();
    }

    public String findColumnById(Class<T> aClass, Long id, String ... tableColumnName) {
        return this.findColumnByIdWithCriteria(aClass, id, null, tableColumnName);
    }

    public String findColumnByIdWithCriteria(Class<T> aClass, Long id, String extWhere, String ... tableColumnName) {
        String selectColumnName = null;
        if (tableColumnName != null && tableColumnName.length > 0) {
            selectColumnName = StringUtils.join((Object[])tableColumnName, (String)",").toLowerCase();
            if (!SqlUtil.isSpiteParams((String)selectColumnName)) {
                selectColumnName = this.selectColumnsAlias(aClass);
            }
        } else {
            selectColumnName = this.selectColumnsAlias(aClass);
        }
        SQL sql = new SQL();
        sql.SELECT(selectColumnName);
        sql.FROM(BaseEoUtil.tableName(aClass));
        String idname = BaseEoUtil.idName(aClass);
        sql.WHERE(this.joinExtWhere(extWhere, idname + " = " + id + " and dr=0"));
        return sql.toString();
    }

    public String findAll(Class<T> aClass) {
        return this.findAllWithCriteria(aClass, null);
    }

    public String findAllWithCriteria(Class<T> aClass, String extWhere) {
        SQL sql = new SQL();
        sql.SELECT(this.selectColumnsAlias(aClass));
        sql.FROM(BaseEoUtil.tableName(aClass));
        sql.WHERE(this.joinExtWhere(extWhere, "dr = 0"));
        return sql.toString();
    }

    public String count(Class<T> aClass) {
        return this.countWithCriteria(aClass, null);
    }

    public String countWithCriteria(Class<T> aClass, String extWhere) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        sql.FROM(BaseEoUtil.tableName(aClass));
        sql.WHERE(this.joinExtWhere(extWhere, "dr = 0"));
        return sql.toString();
    }

    public String countCondition(T obj) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        sql.FROM(obj.tableName());
        if (!"".equals(this.getWhere(obj))) {
            sql.WHERE(this.joinExtWhere(obj, this.getWhere(obj)));
        } else {
            sql.WHERE(this.joinExtWhere(obj, "dr = 0"));
        }
        return sql.toString();
    }

    public String selectColumnsAlias(Class<T> aClass) {
        StringBuffer columnNames = new StringBuffer();
        columnNames.append("id,create_time as createTime,create_person as createPerson,update_time as updateTime,update_person as updatePerson,tenant_id as tenantId,dr as dr");
        for (Class<T> clazz = aClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field[] declaredFields;
                if (clazz == BaseEo.class) continue;
                for (Field field : declaredFields = clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Column.class)) continue;
                    Column column = field.getAnnotation(Column.class);
                    if (!"".equals(columnNames.toString())) {
                        columnNames.append(",");
                    }
                    if (!"".equals(column.name())) {
                        columnNames.append(column.name()).append(" as ").append(field.getName());
                        continue;
                    }
                    columnNames.append(CamelToUnderline.camelToUnderline((String)field.getName())).append(" as ").append(field.getName());
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return columnNames.toString();
    }

    private String getSelectColumnNames(T obj, String ... tableColumnName) {
        String selectColumnName = null;
        if (tableColumnName != null && tableColumnName.length > 0) {
            selectColumnName = StringUtils.join((Object[])tableColumnName, (String)",").toLowerCase();
            if (!SqlUtil.isSpiteParams((String)selectColumnName)) {
                selectColumnName = obj.returnSelectColumnsName();
            }
        } else {
            selectColumnName = obj.returnSelectColumnsName();
        }
        return selectColumnName;
    }

    private String getWhere(T obj) {
        StringBuilder where = new StringBuilder();
        where.append(obj.returnWhereColumnNames());
        if (obj.getId() != null) {
            where.append(" and id = ").append(obj.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)obj.getCreatePerson())) {
            where.append(" and create_person = '").append(obj.getCreatePerson()).append("'");
        }
        if (StringUtils.isNotEmpty((CharSequence)obj.getUpdatePerson())) {
            where.append(" and update_person = '").append(obj.getUpdatePerson()).append("'");
        }
        if (obj.getTenantId() != null) {
            where.append(" and tenant_id = ").append(obj.getTenantId());
        }
        return where.toString();
    }

    private String joinExtWhere(T obj, String where) {
        return this.joinExtWhere(obj.getExtWhere(), where);
    }

    private String joinExtWhere(String extWhere, String where) {
        if (StringUtils.isNotBlank((CharSequence)extWhere) && StringUtils.isNotBlank((CharSequence)where)) {
            where = where + " AND " + extWhere;
        }
        return where;
    }
}

