/*
 * Decompiled with CFR 0.152.
 */
package com.project.dao;

import com.project.dao.IConditionAdder;
import com.project.dao.annotation.Between;
import com.project.util.PropertyUtils;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.persistence.Column;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class BetweenConditionAdder
implements IConditionAdder {
    @Override
    public boolean addCondition(Criteria criteria, Field f, Object cond) {
        boolean dealed = false;
        Between between = f.getAnnotation(Between.class);
        if (null != between && null != f.getAnnotation(Column.class)) {
            Object endValue;
            String endField;
            Object value = PropertyUtils.getProperty(cond, f.getName());
            if (null != value && !"".equals(value)) {
                criteria.add((Criterion)Restrictions.ge((String)f.getName(), value));
                dealed = true;
            }
            if (StringUtils.isBlank((CharSequence)(endField = between.end()))) {
                endField = f.getName() + "End";
            }
            if (PropertyUtils.isReadable(cond, endField) && null != (endValue = PropertyUtils.getProperty(cond, endField)) && !"".equals(endValue)) {
                if (between.type().equals("date")) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String date = sdf.format(endValue) + " 23:59:59";
                    sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    try {
                        criteria.add((Criterion)Restrictions.le((String)f.getName(), (Object)sdf.parse(date)));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else {
                    criteria.add((Criterion)Restrictions.le((String)f.getName(), endValue));
                }
                dealed = true;
            }
        }
        return dealed;
    }
}

