/*
 * Decompiled with CFR 0.152.
 */
package com.project.dao;

import com.project.dao.BetweenConditionAdder;
import com.project.dao.CommonConditionAdder;
import com.project.dao.IConditionAdder;
import com.project.dao.InConditionAdder;
import com.project.dao.ToManyRelationalConditionAdder;
import com.project.dao.ToOneRelationalConditionAdder;
import com.project.util.PropertyUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Id;
import org.hibernate.Criteria;

public class ConditionQuery {
    private static List<IConditionAdder> adders = Arrays.asList(new BetweenConditionAdder(), new InConditionAdder(), new ToOneRelationalConditionAdder(), new ToManyRelationalConditionAdder(), new CommonConditionAdder());

    public static Criteria addCondition(Criteria criteria, Class<?> modelClass, Object cond) {
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        boolean hasPk = false;
        Field pkF = ConditionQuery.getPkField(modelClass);
        if (null != pkF && null != PropertyUtils.getProperty(cond, pkF.getName())) {
            ConditionQuery.dealConditionAdder(criteria, cond, pkF);
            hasPk = true;
        }
        if (!hasPk) {
            for (Field f : PropertyUtils.getAllDeclaredFields(modelClass)) {
                ConditionQuery.dealConditionAdder(criteria, cond, f);
            }
        }
        return criteria;
    }

    private static void dealConditionAdder(Criteria criteria, Object cond, Field f) {
        for (IConditionAdder adder : adders) {
            if (adder.addCondition(criteria, f, cond)) break;
        }
    }

    private static Field getPkField(Class<?> clz) {
        for (Field f : PropertyUtils.getAllDeclaredFields(clz)) {
            if (null == f.getAnnotation(Id.class)) continue;
            return f;
        }
        return null;
    }
}

