/*
 * Decompiled with CFR 0.152.
 */
package com.project.dao;

import com.project.dao.IConditionAdder;
import com.project.dao.annotation.In;
import com.project.util.PropertyUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;

public class InConditionAdder
implements IConditionAdder {
    private static final List<Class<? extends Annotation>> supported = Arrays.asList(Id.class, Column.class, ManyToOne.class, OneToOne.class, Enumerated.class);

    @Override
    public boolean addCondition(Criteria criteria, Field f, Object cond) {
        In in = f.getAnnotation(In.class);
        if (null != in && this.isSupported(f)) {
            String inPropName;
            String string = inPropName = StringUtils.isBlank((CharSequence)in.value()) ? f.getName() + "In" : in.value();
            if (!PropertyUtils.isReadable(cond, inPropName)) {
                return false;
            }
            Object values = PropertyUtils.getProperty(cond, inPropName);
            if (null != values && !"".equals(values)) {
                if (((Collection)values).isEmpty()) {
                    criteria.add(Restrictions.sqlRestriction((String)" 1 <> 1 "));
                } else {
                    criteria.add(Restrictions.in((String)f.getName(), (Collection)((Collection)values)));
                }
                return true;
            }
        }
        return false;
    }

    private boolean isSupported(Field f) {
        for (Class<? extends Annotation> clz : supported) {
            if (null == f.getAnnotation(clz)) continue;
            return true;
        }
        return false;
    }
}

