/*
 * Decompiled with CFR 0.152.
 */
package com.project.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class PropertyUtils {
    public static void copyProperties(Object dest, Object orig) {
        try {
            org.apache.commons.beanutils.PropertyUtils.copyProperties((Object)dest, (Object)orig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> T getProperty(Object bean, String name) {
        if ("this".equals(name)) {
            return (T)bean;
        }
        if (bean instanceof Map) {
            Map map = (Map)bean;
            return (T)map.get(name);
        }
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        bw.setAutoGrowNestedPaths(true);
        return (T)bw.getPropertyValue(name);
    }

    public static void setProperty(Object bean, String name, Object value) {
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        bw.setAutoGrowNestedPaths(true);
        bw.setPropertyValue(name, value);
    }

    public static Field[] getAllDeclaredFields(Class<?> clz) {
        Object[] fields = new Field[]{};
        for (Class<?> curClz = clz; curClz != Object.class; curClz = curClz.getSuperclass()) {
            fields = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])curClz.getDeclaredFields());
        }
        return fields;
    }

    public static boolean isReadable(Object bean, String name) {
        return org.apache.commons.beanutils.PropertyUtils.isReadable((Object)bean, (String)name);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        return org.apache.commons.beanutils.PropertyUtils.getPropertyDescriptors((Object)bean);
    }

    public static Method getReadMethod(PropertyDescriptor descriptor) {
        return org.apache.commons.beanutils.PropertyUtils.getReadMethod((PropertyDescriptor)descriptor);
    }
}

