/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.intercept;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.datalimit.utils.DataLimitContext;
import com.dtyunxi.huieryun.datalimit.utils.SqlUtil;
import com.dtyunxi.huieryun.util.EoUtil;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.persistence.Table;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataLimitIntercept
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(DataLimitIntercept.class);

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("parameterHandler.mappedStatement");
        String sqlType = mappedStatement.getSqlCommandType().toString();
        if (sqlType.equals(SqlCommandType.SELECT.toString())) {
            Class<?> classType = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
            Class<?> eoClass = EoUtil.getEoClass(classType);
            Table tableAnnotation = eoClass.getAnnotation(Table.class);
            String tableName = tableAnnotation.name();
            List<String> subQueryList = DataLimitContext.getLimitRule(tableName);
            Long userId = ServiceContext.getContext().getRequestUserId();
            if (userId != null && !CollectionUtils.isEmpty(subQueryList)) {
                BoundSql boundSql = statementHandler.getBoundSql();
                String originalSql = boundSql.getSql();
                logger.debug("mybatis\u6570\u636e\u6743\u9650\u62e6\u622a\u5668\u62e6\u622a\u5230 {}\u8868 \u67e5\u8be2:{}", (Object)tableName, (Object)originalSql);
                boolean isPageHelperCountQuery = SqlUtil.isPageHelperCountQuery(originalSql);
                if (isPageHelperCountQuery) {
                    logger.debug("\u6709\u5916\u5c42count");
                    originalSql = SqlUtil.getRealSql(originalSql);
                }
                try {
                    String mainTableAlias = SqlUtil.getTableAlias(tableName, originalSql);
                    if (StringUtils.isEmpty((Object)mainTableAlias)) {
                        mainTableAlias = "mt_alias_origin";
                        originalSql = SqlUtil.addTableAlias(tableName, "mt_alias_origin", originalSql);
                    }
                    for (String subQuery : subQueryList) {
                        if (StringUtils.isEmpty((Object)subQuery)) continue;
                        subQuery = subQuery.replace("MAIN_TABLE_ALIAS", mainTableAlias).replace("CURRENT_USER_ID", String.valueOf(userId));
                        originalSql = SqlUtil.appendDataLimit(originalSql, subQuery);
                    }
                    if (isPageHelperCountQuery) {
                        originalSql = SqlUtil.getSimpleCountSql(originalSql, "0");
                    }
                    SqlUtil.appendSql(boundSql, originalSql);
                    logger.debug("mybatis\u6570\u636e\u6743\u9650\u62e6\u622a\u5668\uff1a{}\u8868 \u6539\u5199\u540e\u7684\u67e5\u8be2:{}", (Object)tableName, (Object)originalSql);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else if (CollectionUtils.isEmpty(subQueryList)) {
                logger.debug("{} \u6ca1\u6709\u627e\u5230\u89c4\u5219\uff0c\u53ef\u80fd\u662f\u7528\u6237\u4e0b\u6ca1\u6709\u914d\u7f6e\u89c4\u5219\u6216\u8005\u5f53\u524d\u6b63\u5728\u6267\u884cDas\u4e0b\u7684exists\u65b9\u6cd5,userId:{}", (Object)tableName, (Object)userId);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

