/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.plugin;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.plugin.SourceFromInfo;
import com.dtyunxi.huieryun.plugin.TenantHandler;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.LongValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class TenantQueryPlugin
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(TenantQueryPlugin.class);
    private static final String TABLE_FIELD_TENANT_ID = "tenant_id";
    private static final String TABLE_FIELD_ID = "id";
    private static final String MYSQL_STRING = "mysql";
    private static final String FULL_STOP = ".";
    private final TenantHandler tenantHandler;

    public TenantQueryPlugin(TenantHandler tenantHandler) {
        this.tenantHandler = tenantHandler;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = boundSql.getSql();
        log.debug("before modify sql={}", (Object)sql);
        String newSql = null;
        try {
            MySqlStatementParser parser = new MySqlStatementParser(sql);
            SQLStatement stmt = parser.parseStatement();
            if (stmt instanceof SQLSelectStatement) {
                SQLSelect sqlSelect = ((SQLSelectStatement)stmt).getSelect();
                if (sqlSelect.getQuery() instanceof SQLUnionQuery) {
                    SQLUnionQuery unionQuery = (SQLUnionQuery)sqlSelect.getQuery();
                    newSql = this.doUnionSelect(unionQuery);
                } else {
                    newSql = this.doSelectSql(sql, (MySqlSelectQueryBlock)sqlSelect.getQueryBlock());
                }
            } else if (stmt instanceof MySqlUpdateStatement) {
                MySqlUpdateStatement update = (MySqlUpdateStatement)stmt;
                newSql = this.doUpdateSql(sql, (SQLStatement)update);
            } else if (stmt instanceof MySqlDeleteStatement) {
                MySqlDeleteStatement delete = (MySqlDeleteStatement)stmt;
                newSql = this.doDeleteSql(sql, (SQLStatement)delete);
            }
        }
        catch (Exception e) {
            log.error("deal self filter sql error {}", (Throwable)e);
        }
        if (StringUtils.isNotBlank(newSql)) {
            sql = newSql;
            MetaObject metaObject = SystemMetaObject.forObject((Object)boundSql);
            metaObject.setValue("sql", (Object)sql);
        }
        log.debug("after modify sql={}", (Object)sql);
        return invocation.proceed();
    }

    private String doUnionSelect(SQLUnionQuery unionQuery) {
        SQLSelectQuery left = unionQuery.getLeft();
        SQLSelectQuery right = unionQuery.getRight();
        if (left instanceof SQLUnionQuery) {
            this.doUnionSelect((SQLUnionQuery)left);
        } else {
            this.doSelectSql(String.valueOf(left), (MySqlSelectQueryBlock)left);
        }
        if (right instanceof SQLUnionQuery) {
            this.doUnionSelect((SQLUnionQuery)right);
        } else {
            this.doSelectSql(String.valueOf(right), (MySqlSelectQueryBlock)right);
        }
        return String.valueOf(unionQuery);
    }

    private String doSelectSql(String sql, MySqlSelectQueryBlock select) {
        SQLExpr where = select.getWhere();
        List selectList = select.getSelectList();
        selectList.forEach(e -> {
            if (e.getExpr() instanceof SQLQueryExpr) {
                SQLQueryExpr expr = (SQLQueryExpr)e.getExpr();
                String newFieldSql = this.doSelectSql(String.valueOf(expr), (MySqlSelectQueryBlock)expr.getSubQuery().getQueryBlock());
                SQLExpr subSelect = SQLUtils.toMySqlExpr((String)newFieldSql);
                e.setExpr(subSelect);
                if (log.isInfoEnabled()) {
                    log.info("sql select field have subQuery = {}", (Object)newFieldSql);
                }
            }
        });
        SQLTableSource from = select.getFrom();
        if (from instanceof SQLSubqueryTableSource) {
            String fromString = String.valueOf(from);
            SQLSubqueryTableSource subqueryTableSource = (SQLSubqueryTableSource)from;
            String subQuery = this.doSelectSql(fromString, (MySqlSelectQueryBlock)subqueryTableSource.getSelect().getQueryBlock());
            if (log.isInfoEnabled()) {
                log.info("sql from have subQuery = {}", (Object)subQuery);
            }
            SQLSelect sqlSelectBySql = this.getSqlSelectBySql(subQuery);
            ((SQLSubqueryTableSource)from).setSelect(sqlSelectBySql);
            select.setWhere(this.getNewWhereCondition(select, where, sql, from));
        }
        if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinFrom = (SQLJoinTableSource)from;
            SQLTableSource left = joinFrom.getLeft();
            SQLTableSource right = joinFrom.getRight();
            this.setTableSourceNewSql(left);
            this.setTableSourceNewSql(right);
        }
        select.setWhere(this.getNewWhereCondition(select, where, sql, from));
        return select.toString();
    }

    private String doUpdateSql(String sql, SQLStatement stmt) {
        MySqlUpdateStatement update = (MySqlUpdateStatement)stmt;
        SQLExpr where = update.getWhere();
        update.setWhere(this.getNewWhereCondition(null, where, sql, update.getTableSource()));
        return update.toString();
    }

    private String doDeleteSql(String sql, SQLStatement stmt) {
        MySqlDeleteStatement delete = (MySqlDeleteStatement)stmt;
        SQLExpr where = delete.getWhere();
        delete.setWhere(this.getNewWhereCondition(null, where, sql, delete.getTableSource()));
        return delete.toString();
    }

    private SQLExpr getNewWhereCondition(MySqlSelectQueryBlock select, SQLExpr where, String sql, SQLTableSource tableSource) {
        if (null != where && this.isTenantIdCondition(where)) {
            log.info("the sql contains or condition by tenant_id, sql = {}", (Object)sql);
            return where;
        }
        if (where instanceof SQLInSubQueryExpr) {
            SQLSelect subSelect = ((SQLInSubQueryExpr)where).subQuery;
            String subQuery = String.valueOf(subSelect);
            String newSubQuery = this.doSelectSql(subQuery, (MySqlSelectQueryBlock)subSelect.getQueryBlock());
            SQLSelect sqlSelectBySql = this.getSqlSelectBySql(newSubQuery);
            ((SQLInSubQueryExpr)where).setSubQuery(sqlSelectBySql);
        }
        SQLBinaryOpExpr binaryOpExprWhere = new SQLBinaryOpExpr(MYSQL_STRING);
        ArrayList<SourceFromInfo> tableNameList = new ArrayList<SourceFromInfo>();
        this.getTableNames(select, tableSource, tableNameList);
        if (CollectionUtils.isEmpty(tableNameList)) {
            return where;
        }
        SQLBinaryOpExpr conditionByTableName = this.getWhereConditionByTableList(tableNameList);
        if (log.isInfoEnabled()) {
            log.info("get tableInfos = {}", (Object)JSON.toJSONString(tableNameList));
        }
        if (ObjectUtils.isEmpty((Object)conditionByTableName)) {
            return where;
        }
        if (where == null) {
            return conditionByTableName;
        }
        binaryOpExprWhere.setLeft((SQLExpr)conditionByTableName);
        binaryOpExprWhere.setOperator(SQLBinaryOperator.BooleanAnd);
        binaryOpExprWhere.setRight(where.clone());
        return binaryOpExprWhere;
    }

    private SQLBinaryOpExpr getWhereConditionByTableList(List<SourceFromInfo> tableNameList) {
        if (CollectionUtils.isEmpty(tableNameList = tableNameList.stream().filter(fromInfo -> fromInfo.isNeedAddCondition()).collect(Collectors.toList()))) {
            return null;
        }
        SQLBinaryOpExpr allCondition = new SQLBinaryOpExpr(MYSQL_STRING);
        for (int i = 0; i < tableNameList.size(); ++i) {
            SourceFromInfo tableNameInfo = tableNameList.get(i);
            SQLBinaryOpExpr thisTenantIdWhere = this.getTenantIdCondition(tableNameInfo);
            if (i > 0 && i == tableNameList.size() - 1) {
                allCondition.setOperator(SQLBinaryOperator.BooleanAnd);
                allCondition.setRight((SQLExpr)thisTenantIdWhere);
                break;
            }
            if (tableNameList.size() == 1) {
                allCondition = thisTenantIdWhere;
                break;
            }
            if (allCondition.getLeft() == null) {
                allCondition.setLeft((SQLExpr)thisTenantIdWhere);
                continue;
            }
            SQLBinaryOpExpr condition = this.getAndCondition((SQLBinaryOpExpr)allCondition.getLeft(), thisTenantIdWhere);
            allCondition.setLeft((SQLExpr)condition);
        }
        return allCondition;
    }

    private SQLBinaryOpExpr getAndCondition(SQLBinaryOpExpr left, SQLBinaryOpExpr right) {
        SQLBinaryOpExpr condition = new SQLBinaryOpExpr(MYSQL_STRING);
        condition.setLeft((SQLExpr)left);
        condition.setOperator(SQLBinaryOperator.BooleanAnd);
        condition.setRight((SQLExpr)right);
        return condition;
    }

    private SQLBinaryOpExpr getTenantIdCondition(SourceFromInfo tableNameInfo) {
        SQLBinaryOpExpr tenantIdWhere = new SQLBinaryOpExpr(MYSQL_STRING);
        long tenantId = ((LongValue)this.tenantHandler.getTenantId(true)).getValue();
        if (StringUtils.isEmpty((CharSequence)tableNameInfo.getAlias())) {
            tenantIdWhere.setOperator(SQLBinaryOperator.Equality);
            tenantIdWhere.setLeft((SQLExpr)new SQLIdentifierExpr(TABLE_FIELD_TENANT_ID));
            tenantIdWhere.setRight((SQLExpr)new SQLIntegerExpr((Number)tenantId));
        } else {
            tenantIdWhere.setLeft((SQLExpr)new SQLPropertyExpr(tableNameInfo.getAlias(), TABLE_FIELD_TENANT_ID));
            tenantIdWhere.setOperator(SQLBinaryOperator.Equality);
            tenantIdWhere.setRight((SQLExpr)new SQLIntegerExpr((Number)tenantId));
        }
        return tenantIdWhere;
    }

    private void getTableNames(MySqlSelectQueryBlock select, SQLTableSource tableSource, List<SourceFromInfo> tableNameList) {
        if (tableSource instanceof SQLSubqueryTableSource) {
            SourceFromInfo fromInfo = new SourceFromInfo();
            fromInfo.setSubQuery(true);
            SQLSubqueryTableSource subqueryTableSource = (SQLSubqueryTableSource)tableSource;
            fromInfo.setAlias(subqueryTableSource.getAlias());
            tableNameList.add(fromInfo);
        }
        if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinSource = (SQLJoinTableSource)tableSource;
            SQLTableSource left = joinSource.getLeft();
            SQLTableSource right = joinSource.getRight();
            if (left instanceof SQLSubqueryTableSource) {
                this.getTableNames((MySqlSelectQueryBlock)((SQLSubqueryTableSource)left).getSelect().getQuery(), left, tableNameList);
            }
            if (right instanceof SQLSubqueryTableSource) {
                this.getTableNames((MySqlSelectQueryBlock)((SQLSubqueryTableSource)right).getSelect().getQuery(), right, tableNameList);
            }
            if (left instanceof SQLExprTableSource) {
                this.addOnlyTable(left, tableNameList);
            }
            if (right instanceof SQLExprTableSource) {
                this.addOnlyTable(right, tableNameList);
            }
            if (left instanceof SQLJoinTableSource) {
                this.getTableNames(null, left, tableNameList);
            }
            if (right instanceof SQLJoinTableSource) {
                this.getTableNames(null, right, tableNameList);
            }
        }
        if (tableSource instanceof SQLExprTableSource) {
            this.addOnlyTable(tableSource, tableNameList);
        }
    }

    private void addOnlyTable(SQLTableSource tableSource, List<SourceFromInfo> tableNameList) {
        SourceFromInfo fromInfo = new SourceFromInfo();
        String tableName = String.valueOf(tableSource);
        fromInfo.setTableName(tableName);
        fromInfo.setAlias(tableSource.getAlias());
        tableNameList.add(fromInfo);
    }

    private boolean isTenantIdCondition(SQLExpr where) {
        if (!(where instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)where;
        SQLExpr left = binaryOpExpr.getLeft();
        SQLExpr right = binaryOpExpr.getRight();
        if (!(left instanceof SQLBinaryOpExpr) && !(right instanceof SQLBinaryOpExpr)) {
            String rightOpExpr;
            String leftOpExpr = String.valueOf(left);
            if (leftOpExpr.contains(FULL_STOP)) {
                leftOpExpr = leftOpExpr.substring(leftOpExpr.lastIndexOf(FULL_STOP) + 1);
            }
            if ((rightOpExpr = String.valueOf(right)).contains(FULL_STOP)) {
                rightOpExpr = rightOpExpr.substring(rightOpExpr.lastIndexOf(FULL_STOP) + 1);
            }
            return TABLE_FIELD_TENANT_ID.equalsIgnoreCase(leftOpExpr) || TABLE_FIELD_TENANT_ID.equalsIgnoreCase(rightOpExpr) || TABLE_FIELD_ID.equalsIgnoreCase(leftOpExpr) || TABLE_FIELD_ID.equalsIgnoreCase(rightOpExpr);
        }
        return this.isTenantIdCondition(left) || this.isTenantIdCondition(right);
    }

    private void setTableSourceNewSql(SQLTableSource tableSource) {
        if (!(tableSource instanceof SQLSubqueryTableSource)) {
            return;
        }
        SQLSubqueryTableSource subqueryTableSource = (SQLSubqueryTableSource)tableSource;
        String leftSubQueryString = String.valueOf(subqueryTableSource.getSelect());
        String newLeftSubQueryString = this.doSelectSql(leftSubQueryString, (MySqlSelectQueryBlock)subqueryTableSource.getSelect().getQueryBlock());
        SQLSelect sqlselect = this.getSqlSelectBySql(newLeftSubQueryString);
        subqueryTableSource.setSelect(sqlselect);
    }

    private SQLSelect getSqlSelectBySql(String sql) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (String)MYSQL_STRING);
        List parseStatementList = parser.parseStatementList();
        if (CollectionUtils.isEmpty((Collection)parseStatementList)) {
            return null;
        }
        SQLSelectStatement sstmt = (SQLSelectStatement)parseStatementList.get(0);
        SQLSelect sqlselect = sstmt.getSelect();
        return sqlselect;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

