/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JacksonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JacksonUtil.class);
    public static final TypeReference<HashMap<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<HashMap<String, Object>>(){};
    public static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T readValue(String jsonStr, Class<T> valueType) {
        if (StrUtil.isBlank((CharSequence)jsonStr) || "null".equals(jsonStr)) {
            logger.warn("\u6ce8\u610f\uff1a\u8bfb\u5230\u7a7a\u5b57\u7b26\u4e32,jsonStr={}", (Object)jsonStr);
            return null;
        }
        try {
            if (!jsonStr.startsWith("\"") && (ClassUtil.isBasicType(valueType) || valueType.equals(String.class))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u76f4\u63a5\u4f7f\u7528\u7c7b\u578b\u8f6c\u6362\uff01class={}", (Object)valueType.getName());
                }
                return (T)Convert.convert(valueType, (Object)jsonStr);
            }
            return (T)objectMapper.readValue(jsonStr, valueType);
        }
        catch (Exception e) {
            if (ClassUtil.isBasicType(valueType) || valueType.equals(String.class)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u76f4\u63a5\u4f7f\u7528\u7c7b\u578b\u8f6c\u6362\uff01class={}", (Object)valueType.getName());
                }
                return (T)Convert.convert(valueType, (Object)jsonStr);
            }
            logger.error("JacksonUtil.readValue(String,Class<T>)\u6267\u884c\u5f02\u5e38,jsonStr={},valueType={}", (Object)jsonStr, (Object)JacksonUtil.toJson(valueType));
            throw new BusinessRuntimeException("JacksonUtil.readValue(String,Class<T>)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static <T> T readValue(String jsonStr, Type type) {
        if (type instanceof Class) {
            return JacksonUtil.readValue(jsonStr, (Class)type);
        }
        JavaType javaType = objectMapper.getTypeFactory().constructType(type);
        try {
            return (T)objectMapper.readValue(jsonStr, javaType);
        }
        catch (Exception e) {
            logger.error("JacksonUtil.readValue(String,Type)\u6267\u884c\u5f02\u5e38,jsonStr={},type={}", (Object)jsonStr, (Object)JacksonUtil.toJson(type));
            throw new BusinessRuntimeException("JacksonUtil.readValue(String,Type)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static <T> T readValue(String jsonStr, TypeReference<T> valueTypeRef) {
        if (StrUtil.isBlank((CharSequence)jsonStr) || "null".equals(jsonStr)) {
            logger.warn("\u6ce8\u610f\uff1a\u8bfb\u5230\u7a7a\u5b57\u7b26\u4e32,jsonStr={}", (Object)jsonStr);
            return null;
        }
        Type valueType = valueTypeRef.getType();
        if (valueType instanceof Class) {
            return JacksonUtil.readValue(jsonStr, (Class)valueType);
        }
        try {
            return (T)objectMapper.readValue(jsonStr, valueTypeRef);
        }
        catch (Exception e) {
            logger.error("JacksonUtil.readValue(String,TypeReference<T>)\u6267\u884c\u5f02\u5e38,jsonStr={},type={}", (Object)jsonStr, (Object)JacksonUtil.toJson(valueType));
            throw new BusinessRuntimeException("JacksonUtil.readValue(String,TypeReference<T>)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static <T> T readValue(String jsonStr, Class<?> parametrized, Class<?> ... parameterClasses) {
        if (StrUtil.isBlank((CharSequence)jsonStr) || "null".equals(jsonStr)) {
            logger.warn("\u6ce8\u610f\uff1a\u8bfb\u5230\u7a7a\u5b57\u7b26\u4e32,jsonStr={}", (Object)jsonStr);
            return null;
        }
        JavaType type = objectMapper.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
        try {
            return (T)objectMapper.readValue(jsonStr, type);
        }
        catch (IOException e) {
            logger.error("JacksonUtil.readValue(String,Class<?>,Class...)\u6267\u884c\u5f02\u5e38,jsonStr={},type={}", (Object)jsonStr, (Object)JacksonUtil.toJson(type));
            throw new BusinessRuntimeException("JacksonUtil.readValue(String,Class<?>,Class...)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static <T> List<T> readList(String jsonStr, Class<T> valueType) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)objectMapper.readValue(jsonStr, javaType);
        }
        catch (IOException e) {
            logger.error("JacksonUtil.readList(String,Type)\u6267\u884c\u5f02\u5e38,jsonStr={},valueType={}", (Object)jsonStr, (Object)JacksonUtil.toJson(valueType));
            throw new BusinessRuntimeException("JacksonUtil.readList(String,Type)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static <T> List<T> readList(String jsonStr, Type type) {
        try {
            JavaType valueType = objectMapper.getTypeFactory().constructType(type);
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(ArrayList.class, new JavaType[]{valueType});
            return (List)objectMapper.readValue(jsonStr, javaType);
        }
        catch (IOException e) {
            logger.error("JacksonUtil.readList(String,Type)\u6267\u884c\u5f02\u5e38,jsonStr={},type={}", (Object)jsonStr, (Object)JacksonUtil.toJson(type));
            throw new BusinessRuntimeException("JacksonUtil.readList(String,Type)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static String toJSon(Object object) {
        return JacksonUtil.toJson(object);
    }

    public static String toJson(Object object) {
        if (StrUtil.isBlankIfStr((Object)object)) {
            logger.warn("\u6ce8\u610f\uff1a\u8bbe\u7f6e\u7a7a\u5bf9\u8c61\u6216\u8005\u7a7a\u5b57\u7b26\u4e32,\u7ec4\u4ef6\u4e3a\u4e86\u907f\u514d\u8bbe\u7f6e\u7f13\u5b58\u51fa\u9519\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u7a7a\u5b57\u7b26\uff01object={}", object);
            return "";
        }
        try {
            if (ClassUtil.isBasicType(object.getClass()) || String.class.equals(object.getClass())) {
                return String.valueOf(object);
            }
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("JacksonUtil.toJSon\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static Map<String, Object> toMap(String jsonStr) {
        if (StrUtil.isBlank((CharSequence)jsonStr) || "null".equals(jsonStr)) {
            return new HashMap<String, Object>(0);
        }
        try {
            return (Map)objectMapper.readValue(jsonStr, MAP_TYPE_REFERENCE);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("JacksonUtil.toMap(String)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

