/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd;

import com.coreos.jetcd.EtcdMaintenance;
import com.coreos.jetcd.api.AlarmMember;
import com.coreos.jetcd.api.AlarmRequest;
import com.coreos.jetcd.api.AlarmResponse;
import com.coreos.jetcd.api.AlarmType;
import com.coreos.jetcd.api.DefragmentRequest;
import com.coreos.jetcd.api.DefragmentResponse;
import com.coreos.jetcd.api.MaintenanceGrpc;
import com.coreos.jetcd.api.SnapshotRequest;
import com.coreos.jetcd.api.SnapshotResponse;
import com.coreos.jetcd.api.StatusRequest;
import com.coreos.jetcd.api.StatusResponse;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.stub.StreamObserver;

public class EtcdMaintenanceImpl
implements EtcdMaintenance {
    private MaintenanceGrpc.MaintenanceFutureStub futureStub;
    private MaintenanceGrpc.MaintenanceStub streamStub;
    private volatile StreamObserver<SnapshotResponse> snapshotObserver;
    private volatile EtcdMaintenance.SnapshotCallback snapshotCallback;

    public EtcdMaintenanceImpl(MaintenanceGrpc.MaintenanceFutureStub futureStub, MaintenanceGrpc.MaintenanceStub streamStub) {
        this.futureStub = futureStub;
        this.streamStub = streamStub;
    }

    @Override
    public ListenableFuture<AlarmResponse> listAlarms() {
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(AlarmType.NONE).setAction(AlarmRequest.AlarmAction.GET).setMemberID(0L).build();
        return this.futureStub.alarm(alarmRequest);
    }

    @Override
    public ListenableFuture<AlarmResponse> disalarm(AlarmMember member) {
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(AlarmType.NOSPACE).setAction(AlarmRequest.AlarmAction.DEACTIVATE).setMemberID(member.getMemberID()).build();
        Preconditions.checkArgument((member.getMemberID() != 0L ? 1 : 0) != 0, (Object)"the member id can not be 0");
        Preconditions.checkArgument((member.getAlarm() != AlarmType.NONE ? 1 : 0) != 0, (Object)"alarm type can not be NONE");
        return this.futureStub.alarm(alarmRequest);
    }

    @Override
    public ListenableFuture<DefragmentResponse> defragmentMember() {
        return this.futureStub.defragment(DefragmentRequest.getDefaultInstance());
    }

    @Override
    public ListenableFuture<StatusResponse> statusMember() {
        return this.futureStub.status(StatusRequest.getDefaultInstance());
    }

    @Override
    public synchronized void setSnapshotCallback(EtcdMaintenance.SnapshotCallback callback) {
        if (this.snapshotObserver == null) {
            this.snapshotObserver = new StreamObserver<SnapshotResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onNext(SnapshotResponse snapshotResponse) {
                    if (EtcdMaintenanceImpl.this.snapshotCallback != null) {
                        EtcdMaintenanceImpl etcdMaintenanceImpl = EtcdMaintenanceImpl.this;
                        synchronized (etcdMaintenanceImpl) {
                            if (EtcdMaintenanceImpl.this.snapshotCallback != null) {
                                EtcdMaintenanceImpl.this.snapshotCallback.onSnapShot(snapshotResponse);
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onError(Throwable throwable) {
                    EtcdMaintenanceImpl etcdMaintenanceImpl = EtcdMaintenanceImpl.this;
                    synchronized (etcdMaintenanceImpl) {
                        if (EtcdMaintenanceImpl.this.snapshotCallback != null) {
                            EtcdMaintenanceImpl.this.snapshotCallback.onError(throwable);
                        }
                        EtcdMaintenanceImpl.this.snapshotObserver = null;
                    }
                }

                public void onCompleted() {
                }
            };
        }
        this.streamStub.snapshot(SnapshotRequest.getDefaultInstance(), this.snapshotObserver);
    }

    @Override
    public synchronized void removeSnapShotCallback() {
        if (this.snapshotObserver != null) {
            this.snapshotObserver.onCompleted();
            this.snapshotCallback = null;
            this.snapshotObserver = null;
        }
    }
}

