/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.op;

import com.coreos.jetcd.api.TxnRequest;
import com.coreos.jetcd.op.Cmp;
import com.coreos.jetcd.op.Op;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class Txn {
    private static final ImmutableList<?> EMPTY_LIST = ImmutableList.copyOf((Object[])new Object[0]);
    private final List<Cmp> cmpList;
    private final List<Op> successOpList;
    private final List<Op> failureOpList;

    public static Builder newBuilder() {
        return new Builder();
    }

    public TxnRequest toTxnRequest() {
        TxnRequest.Builder requestBuilder = TxnRequest.newBuilder();
        for (Cmp c : this.cmpList) {
            requestBuilder.addCompare(c.toCompare());
        }
        for (Op o : this.successOpList) {
            requestBuilder.addSuccess(o.toRequestOp());
        }
        for (Op o : this.failureOpList) {
            requestBuilder.addFailure(o.toRequestOp());
        }
        return requestBuilder.build();
    }

    private Txn(List<Cmp> cmpList, List<Op> successOpList, List<Op> failureOpList) {
        this.cmpList = cmpList;
        this.successOpList = successOpList;
        this.failureOpList = failureOpList;
    }

    static /* synthetic */ ImmutableList access$100() {
        return EMPTY_LIST;
    }

    public static class Builder {
        private List<Cmp> cmpList = Txn.access$100();
        private List<Op> successOpList = Txn.access$100();
        private List<Op> failureOpList = Txn.access$100();

        private Builder() {
        }

        public Builder If(Cmp ... cmps) {
            this.cmpList = Lists.newArrayList((Object[])cmps);
            return this;
        }

        public Builder Then(Op ... ops) {
            this.successOpList = Lists.newArrayList((Object[])ops);
            return this;
        }

        public Builder Else(Op ... ops) {
            this.failureOpList = Lists.newArrayList((Object[])ops);
            return this;
        }

        public Txn build() {
            return new Txn(this.cmpList, this.successOpList, this.failureOpList);
        }
    }
}

