/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.resolver;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.ResolvedServerInfo;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractEtcdNameResolver
extends NameResolver {
    private final String authority;
    private final SharedResourceHolder.Resource<ExecutorService> executorResource;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    @GuardedBy(value="this")
    private ExecutorService executor;
    private final Runnable resolutionRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameResolver.Listener savedListener;
            AbstractEtcdNameResolver abstractEtcdNameResolver = AbstractEtcdNameResolver.this;
            synchronized (abstractEtcdNameResolver) {
                if (AbstractEtcdNameResolver.this.shutdown) {
                    return;
                }
                AbstractEtcdNameResolver.this.resolving = true;
                savedListener = AbstractEtcdNameResolver.this.listener;
            }
            try {
                List<ResolvedServerInfo> servers = AbstractEtcdNameResolver.this.getServers();
                savedListener.onUpdate(Collections.singletonList(servers), Attributes.EMPTY);
            }
            finally {
                abstractEtcdNameResolver = AbstractEtcdNameResolver.this;
                synchronized (abstractEtcdNameResolver) {
                    AbstractEtcdNameResolver.this.resolving = false;
                }
            }
        }
    };

    public AbstractEtcdNameResolver(String name, SharedResourceHolder.Resource<ExecutorService> executorResource) {
        this.executorResource = executorResource;
        URI nameUri = URI.create("//" + name);
        this.authority = (String)Preconditions.checkNotNull((Object)nameUri.getAuthority(), (String)"nameUri (%s) doesn't have an authority", (Object[])new Object[]{nameUri});
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.executor = (ExecutorService)SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    public final synchronized void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    public final synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.executor != null) {
            this.executor = (ExecutorService)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
    }

    @GuardedBy(value="this")
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolutionRunnable);
    }

    protected abstract List<ResolvedServerInfo> getServers();
}

