/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.lock.provider.redis;

import com.dtyunxi.huieryun.lock.api.AbstractLockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.lock.enums.WorkModel;
import com.dtyunxi.huieryun.lock.vo.LockRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLockService
extends AbstractLockService {
    private static final Logger logger = LoggerFactory.getLogger(RedisLockService.class);
    private RedissonClient redisson;

    public void init(LockRegistryVo lockVo) {
        super.init(lockVo);
        Config config = new Config();
        WorkModel workModel = WorkModel.getWorkModelByName((String)lockVo.getWorkModel());
        if (workModel == null) {
            throw new IllegalArgumentException("\u5206\u5e03\u5f0f\u9501\u8bbe\u7f6e\u6a21\u5f0f\u9519\u8bef\uff01");
        }
        switch (workModel) {
            case SINGLE: {
                SingleServerConfig singleSerververConfig = config.useSingleServer();
                singleSerververConfig.setConnectionMinimumIdleSize(lockVo.getMasterConnectionMinimumIdleSize());
                singleSerververConfig.setAddress(lockVo.getEndpoints()[0]);
                if (!StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) break;
                singleSerververConfig.setPassword(lockVo.getPasswd());
                break;
            }
            case SENTINE: {
                SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
                sentinelServersConfig.setMasterConnectionMinimumIdleSize(lockVo.getMasterConnectionMinimumIdleSize());
                sentinelServersConfig.setSlaveConnectionMinimumIdleSize(lockVo.getSlaveConnectionMinimumIdleSize());
                sentinelServersConfig.addSentinelAddress(lockVo.getEndpoints());
                if (!StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) break;
                sentinelServersConfig.setPassword(lockVo.getPasswd());
                break;
            }
            case CLUSTER: {
                ClusterServersConfig clusterServersConfig = config.useClusterServers();
                clusterServersConfig.setMasterConnectionMinimumIdleSize(lockVo.getMasterConnectionMinimumIdleSize());
                clusterServersConfig.setSlaveConnectionMinimumIdleSize(lockVo.getSlaveConnectionMinimumIdleSize());
                clusterServersConfig.addNodeAddress(lockVo.getEndpoints());
                if (!StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) break;
                clusterServersConfig.setPassword(lockVo.getPasswd());
                break;
            }
            case MASTERSLAVE: {
                MasterSlaveServersConfig masterSlaveServersConfig = config.useMasterSlaveServers();
                masterSlaveServersConfig.setMasterConnectionMinimumIdleSize(lockVo.getMasterConnectionMinimumIdleSize());
                masterSlaveServersConfig.setSlaveConnectionMinimumIdleSize(lockVo.getSlaveConnectionMinimumIdleSize());
                String master = lockVo.getEndpoints()[0];
                masterSlaveServersConfig.setMasterAddress(master);
                if (lockVo.getEndpoints().length > 1) {
                    String[] slaves = Arrays.copyOfRange(lockVo.getEndpoints(), 1, lockVo.getEndpoints().length);
                    masterSlaveServersConfig.addSlaveAddress(slaves);
                }
                if (!StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) break;
                masterSlaveServersConfig.setPassword(lockVo.getPasswd());
            }
        }
        this.redisson = Redisson.create((Config)config);
    }

    public Mutex lock(String tableName, Long primaryKey) {
        return this.lock(tableName, String.valueOf(primaryKey), this.lockVo.getWaitTimeout());
    }

    public Mutex lock(String tableName, String primaryKey) {
        return this.lock(tableName, primaryKey, this.lockVo.getWaitTimeout());
    }

    public Mutex lock(String tableName, Long primaryKey, int waitTimeout) {
        return this.lock(tableName, String.valueOf(primaryKey), waitTimeout);
    }

    public Mutex lock(String tableName, String primaryKey, int waitTimeout) {
        return this.lock(tableName, primaryKey, waitTimeout, this.lockVo.getLeaseTime(), TimeUnit.SECONDS);
    }

    public Mutex lock(String tableName, String primaryKey, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        Mutex mutex = new Mutex(lockKey);
        RLock rLock = this.redisson.getFairLock(lockKey);
        try {
            boolean res = rLock.tryLock((long)waitTimeout, (long)leaseTime, timeUnit);
            if (!res) {
                throw new BusinessRuntimeException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (Throwable)e);
        }
        return mutex;
    }

    public boolean unlock(Mutex mutex) {
        if (null == mutex) {
            return true;
        }
        try {
            RLock rLock = this.redisson.getFairLock(mutex.getLockKey());
            rLock.unlock();
            return true;
        }
        catch (Exception e) {
            logger.error("\u89e3\u9501\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
    }

    public boolean isLocked(String tableName, Long primaryKey) {
        return this.isLocked(tableName, String.valueOf(primaryKey));
    }

    public boolean isLocked(String tableName, String primaryKey) {
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        RLock rLock = this.redisson.getFairLock(lockKey);
        return rLock.isLocked();
    }

    public String getLockAcquirer(String tableName, Long primaryKey) {
        throw new BusinessRuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    public String getLockAcquirer(String tableName, String primaryKey) {
        throw new BusinessRuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    public void shutdown() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }
}

