/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log.filter;

import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.huieryun.log.RequestId;
import com.taobao.eagleeye.EagleEye;
import com.taobao.hsf.invocation.Invocation;
import com.taobao.hsf.invocation.InvocationHandler;
import com.taobao.hsf.invocation.RPCResult;
import com.taobao.hsf.invocation.filter.RPCFilter;
import com.taobao.hsf.util.concurrent.ListenableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class HSFTraceIdServerFilter
implements RPCFilter {
    private static final Logger logger = LoggerFactory.getLogger(HSFTraceIdServerFilter.class);
    private String traceId = null;

    public ListenableFuture<RPCResult> invoke(InvocationHandler invocationHandler, Invocation invocation) throws Throwable {
        this.traceId = EagleEye.getTraceId();
        if (StringUtils.isNotEmpty((CharSequence)this.traceId)) {
            MDC.put((String)"traceId", (String)this.traceId);
            MDC.put((String)"yes.req.requestId", (String)this.traceId);
        } else {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
        }
        return invocationHandler.invoke(invocation);
    }

    public void onResponse(Invocation invocation, RPCResult rpcResult) {
        this.traceId = EagleEye.getTraceId();
        if (StringUtils.isNotEmpty((CharSequence)this.traceId)) {
            MDC.remove((String)"traceId");
        }
        MDC.remove((String)"yes.req.requestId");
    }
}

