/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.aliyun;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.dtyunxi.huieryun.mq.api.AbstractConsumer;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.aliyun.assembler.MessageAssembler;
import com.dtyunxi.huieryun.mq.provider.aliyun.util.AliyunConsumerHelper;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunConsumer
extends AbstractConsumer {
    private static Logger logger = LoggerFactory.getLogger(AliyunConsumer.class);
    private static final AliyunConsumer single = new AliyunConsumer();
    private static final ConcurrentHashMap<String, Consumer> consumerMap = new ConcurrentHashMap();

    private AliyunConsumer() {
    }

    public static AliyunConsumer getInstance() {
        return single;
    }

    public void createConsumer(MessageRegistryVo messageRegistryVo) {
        this.messageRegistryVo = messageRegistryVo;
    }

    public <T> MessageResponse receiveMessage(String topicName, String routingKey, IMessageProcessor<T> processor) {
        if (logger.isInfoEnabled()) {
            logger.info("receiveMessage,topicName:{},routingKey:{}", (Object)topicName, (Object)routingKey);
        }
        return this.subscribe(topicName, routingKey, processor);
    }

    public <T> MessageResponse receiveMessage(String topic, String consumer, String routingKey, IMessageProcessor<T> processor) {
        return this.subscribe(topic, consumer, routingKey, processor);
    }

    public MessageResponse receiveMessage(String topic, String consumer, Map<String, IMessageProcessor> processorMap) {
        return this.subscribe(topic, consumer, processorMap);
    }

    public <T> MessageResponse subscribe(String topicName, String consumer, String routingKey, IMessageProcessor<T> processor) {
        if (logger.isInfoEnabled()) {
            logger.info("subscribeMessage,topicName:{},consumer:{},routingKey:{}", new Object[]{topicName, consumer, routingKey});
        }
        try {
            this.toSubscribe(this.messageRegistryVo, topicName, consumer, routingKey, processor, "CLUSTERING");
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} consumer:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    public <T> MessageResponse subscribe(String topicName, String routingKey, IMessageProcessor<T> processor) {
        return this.toSubscribe(this.messageRegistryVo, topicName, routingKey, processor, "CLUSTERING");
    }

    public <T> MessageResponse subscribe(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        String subExpression = this.getSubExpression(routingKeys);
        return this.toSubscribe(this.messageRegistryVo, topicName, subExpression, processor, "CLUSTERING");
    }

    public MessageResponse subscribe(String consumer, Map<String, Map<String, IMessageProcessor>> messageProcessorMap) {
        if (logger.isInfoEnabled()) {
            logger.info("consumer={}", (Object)consumer);
        }
        this.toSubscribe(this.messageRegistryVo, consumer, messageProcessorMap, "CLUSTERING");
        return MessageResponse.SUCCESS;
    }

    public MessageResponse subscribe(String topic, String consumer, Map<String, IMessageProcessor> messageProcessorMap) {
        try {
            this.toSingleTopicSubscribe(this.messageRegistryVo, topic, consumer, messageProcessorMap, "CLUSTERING");
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} ", (Object)topic, (Object)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    private void toSubscribe(MessageRegistryVo messageRegistryVo, String consumerId, Map<String, Map<String, IMessageProcessor>> messageProcessorMap, String messageModel) {
        if (logger.isInfoEnabled()) {
            logger.info("consumer={}", (Object)consumerId);
        }
        try {
            if (!consumerMap.containsKey(consumerId)) {
                this.createConsumer(messageRegistryVo, consumerId, messageModel);
            }
            Consumer consumer = consumerMap.get(consumerId);
            for (String topicName : messageProcessorMap.keySet()) {
                String subExpression = this.getSubExpression(messageProcessorMap.get(topicName).keySet().toArray());
                consumer.subscribe(topicName, subExpression, this.consumerMessageListener(messageProcessorMap.get(topicName)));
            }
            if (!consumer.isStarted()) {
                consumer.start();
            }
            if (logger.isInfoEnabled()) {
                logger.info("Connected to {}", (Object)messageRegistryVo.getAddressesString());
            }
        }
        catch (Exception e) {
            logger.error("Failed to connect to {}", (Object)messageRegistryVo.getAddressesString(), (Object)e);
        }
    }

    private void createConsumer(MessageRegistryVo messageRegistryVo, String consumerId, String messageModel) {
        if (logger.isInfoEnabled()) {
            logger.info("consumer={}", (Object)consumerId);
        }
        Properties properties = AliyunConsumerHelper.getProperties(messageRegistryVo);
        properties.setProperty("GROUP_ID", consumerId);
        properties.setProperty("ConsumerId", consumerId);
        properties.put("MessageModel", messageModel);
        properties.setProperty("ConsumeThreadNums", String.valueOf(messageRegistryVo.getConsumeThreadNums()));
        Consumer consumer = ONSFactory.createConsumer((Properties)properties);
        consumerMap.put(consumerId, consumer);
    }

    private MessageListener consumerMessageListener(final Map<String, IMessageProcessor> messageProcessorMap) {
        return new MessageListener(){

            public Action consume(Message message, ConsumeContext context) {
                IMessageProcessor messageProcessor;
                if (logger.isInfoEnabled()) {
                    logger.info("\u63a5\u6536\u5230\u6d88\u606f,topic={},tags={},msgId:{},msgKeys={}", new Object[]{message.getTopic(), message.getTag(), message.getMsgID(), message.getKey()});
                }
                try {
                    if (messageProcessorMap == null || messageProcessorMap.isEmpty()) {
                        logger.warn("\u65e0\u6d88\u606f\u8ba2\u9605\u8005\uff0ctag={}", (Object)message.getTag());
                        return Action.CommitMessage;
                    }
                    messageProcessor = (IMessageProcessor)messageProcessorMap.get(message.getTag());
                    if (messageProcessor == null) {
                        logger.warn("\u65e0\u6d88\u606f\u8ba2\u9605\u8005\uff0ctag={}", (Object)message.getTag());
                        return Action.CommitMessage;
                    }
                }
                catch (Throwable e) {
                    if (logger.isDebugEnabled()) {
                        logger.error("\u5176\u4ed6\u672a\u77e5\u5f02\u5e38\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217,\u5f02\u5e38\u6d88\u606f\uff1a", e);
                    } else {
                        logger.error("\u5176\u4ed6\u672a\u77e5\u5f02\u5e38\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217,\u5f02\u5e38\u6d88\u606f\uff1a{}", (Object)e.getMessage());
                    }
                    return Action.ReconsumeLater;
                }
                MQMessageVo messageVo = MessageAssembler.messageToVo(message, AliyunConsumer.this.messageRegistryVo.getSerializeCode());
                messageVo.setPassSvcContext(AliyunConsumer.this.messageRegistryVo.isPassSvcContext());
                MessageResponse response = messageProcessor.process(messageVo);
                if ("error".equals(response.getResultMsg())) {
                    return Action.ReconsumeLater;
                }
                return Action.CommitMessage;
            }
        };
    }

    private void toSingleTopicSubscribe(MessageRegistryVo messageRegistryVo, String topicName, String consumerId, Map<String, IMessageProcessor> messageProcessorMap, String messageModel) {
        try {
            if (!consumerMap.containsKey(consumerId)) {
                this.createConsumer(messageRegistryVo, consumerId, messageModel);
            }
            Consumer consumer = consumerMap.get(consumerId);
            String subExpression = this.getSubExpression(messageProcessorMap.keySet().toArray());
            consumer.subscribe(topicName, subExpression, this.consumerMessageListener(messageProcessorMap));
            if (!consumer.isStarted()) {
                consumer.start();
            }
            if (logger.isInfoEnabled()) {
                logger.info("Connected to {}", (Object)messageRegistryVo.getAddressesString());
            }
        }
        catch (Exception e) {
            logger.error("Failed to connect to {}", (Object)messageRegistryVo.getAddressesString(), (Object)e);
        }
    }

    public MessageResponse unsubscribe(String topicName, String routingKey) {
        try {
            Consumer consumer = consumerMap.get(this.messageRegistryVo.getConsumerId());
            consumer.unsubscribe(topicName);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u8ba2\u9605\u5931\u8d25\uff0ctopicName\uff1a{}", (Object)topicName, (Object)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    private void toSubscribe(MessageRegistryVo messageRegistryVo, String topicName, String consumerId, String routingKey, IMessageProcessor processor, String messageModel) {
        HashMap<String, IMessageProcessor> messageProcessorMap = new HashMap<String, IMessageProcessor>();
        messageProcessorMap.put(routingKey, processor);
        this.toSingleTopicSubscribe(messageRegistryVo, topicName, consumerId, messageProcessorMap, messageModel);
    }

    private <T> MessageResponse toSubscribe(MessageRegistryVo messageRegistryVo, String topicName, String routingKey, IMessageProcessor<T> processor, String messageModel) {
        try {
            this.toSubscribe(messageRegistryVo, topicName, messageRegistryVo.getConsumerId(), routingKey, processor, messageModel);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} consumer:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    public <T> MessageResponse subscribeBroadcastMessage(String topicName, String routingKey, IMessageProcessor<T> processor) {
        return this.toSubscribe(this.messageRegistryVo, topicName, routingKey, processor, "BROADCASTING");
    }

    public <T> MessageResponse subscribeBroadcastMessage(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        String subExpression = this.getSubExpression(routingKeys);
        return this.toSubscribe(this.messageRegistryVo, topicName, subExpression, processor, "BROADCASTING");
    }
}

