/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.aliyun.assembler;

import com.aliyun.openservices.ons.api.Message;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.util.IdGenrator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.util.CollectionUtils;

public class MessageAssembler {
    private MessageAssembler() {
    }

    public static MQMessageVo messageToVo(Message message, SerializeCode serializeCode) {
        MQMessageVo messageVo = new MQMessageVo(serializeCode);
        HashMap headerList = new HashMap(message.getUserProperties().size());
        if (!message.getUserProperties().isEmpty()) {
            message.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                if (key.equals("mqMessageBodyClassInfo")) {
                    messageVo.setMessageBodyClass(value.toString());
                } else {
                    headerList.put(key.toString(), value.toString());
                }
            }));
        }
        messageVo.setHeaderList(headerList);
        messageVo.setMessageKey(message.getKey());
        messageVo.setDelayTime((message.getStartDeliverTime() - System.currentTimeMillis()) / 1000L);
        messageVo.setMessageBody(message.getBody());
        messageVo.setTag(message.getTag());
        messageVo.setTopic(message.getTopic());
        messageVo.setMessageId(message.getMsgID());
        return messageVo;
    }

    public static Message messageVoToMessage(MQMessageVo messageVo) {
        long delayTime;
        Message message = new Message(messageVo.getTopic(), messageVo.getTag(), messageVo.getMessageBody());
        message.setKey(String.valueOf(IdGenrator.getDistributedId()));
        if (!CollectionUtils.isEmpty((Map)messageVo.getHeaderList())) {
            messageVo.getHeaderList().forEach((key, value) -> message.putUserProperties(key, value));
        }
        if ((delayTime = messageVo.getDelayTime()) > 0L) {
            message.setStartDeliverTime(System.currentTimeMillis() + delayTime * 1000L);
        }
        if (messageVo.getSerializeCode().isJdkSerializer()) {
            return message;
        }
        message.putUserProperties("mqMessageBodyClassInfo", messageVo.getMessageBodyClass());
        return message;
    }
}

