/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket;

import com.dtyunxi.huieryun.mq.api.AbstractProducer;
import com.dtyunxi.huieryun.mq.provider.rocket.impl.factory.RocketProducerFactory;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.retry.vo.RetryerRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketProducer
extends AbstractProducer {
    private static Logger logger = LoggerFactory.getLogger(RocketProducer.class);
    private static final AtomicInteger TIMES = new AtomicInteger(0);
    private static volatile RocketProducer single = null;
    private DefaultMQProducer defaultMQProducer;

    private RocketProducer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RocketProducer getInstance() {
        if (single != null) return single;
        Class<RocketProducer> clazz = RocketProducer.class;
        synchronized (RocketProducer.class) {
            if (single != null) return single;
            single = new RocketProducer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected Boolean connectMQServer() {
        try {
            this.defaultMQProducer = RocketProducerFactory.getRocketProducer(this.messageRegistryVo);
            this.defaultMQProducer.start();
            return true;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaRocket Producer\u65f6\u51fa\u9519\uff0c host:{}", (Object)this.messageRegistryVo.getHost(), (Object)e);
            return false;
        }
    }

    public MessageResponse sendSingleMessage(String topicName, String queueName, Object message, long delayTime) {
        return this.sendMessage(topicName, queueName, message, delayTime);
    }

    public MessageResponse sendAsyncSingleMessage(String topic, String queueName, Object message, long delayTime, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        return this.sendAsyncMessage(topic, queueName, message, delayTime, callback);
    }

    public MessageResponse sendMessage(String topicName, String routingKey, Object message, long delayTime) {
        try {
            Message msg = new Message(topicName, routingKey, SerializeCode.serialize((Object)message));
            msg.setKeys("ORDERID_" + this.getMessageId());
            if (delayTime > 0L) {
                msg.setDelayTimeLevel(this.getDelayTimeLevel(delayTime));
            }
            SendResult result = this.sendMessage(msg);
            return new MessageResponse((Object)result.getMsgId());
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    private int getDelayTimeLevel(long delayTime) {
        if (delayTime <= 1L) {
            return 1;
        }
        if (delayTime <= 5L) {
            return 2;
        }
        if (delayTime <= 10L) {
            return 3;
        }
        if (delayTime <= 30L) {
            return 4;
        }
        if (delayTime <= 60L) {
            return 5;
        }
        if (delayTime <= 120L) {
            return 6;
        }
        if (delayTime <= 180L) {
            return 7;
        }
        if (delayTime <= 240L) {
            return 8;
        }
        if (delayTime <= 300L) {
            return 9;
        }
        if (delayTime <= 360L) {
            return 10;
        }
        if (delayTime <= 420L) {
            return 11;
        }
        if (delayTime <= 480L) {
            return 12;
        }
        if (delayTime <= 540L) {
            return 13;
        }
        if (delayTime <= 600L) {
            return 14;
        }
        if (delayTime <= 1200L) {
            return 15;
        }
        if (delayTime <= 1800L) {
            return 16;
        }
        if (delayTime <= 3600L) {
            return 17;
        }
        if (delayTime <= 7200L) {
            return 18;
        }
        return 18;
    }

    public MessageResponse sendAsyncMessage(String routingKey, Object message, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        return this.sendAsyncMessage(this.messageRegistryVo.getTopicName(), routingKey, message, 0L, callback);
    }

    public MessageResponse sendAsyncMessage(String routingKey, Object message, long delayTime, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        return this.sendAsyncMessage(this.messageRegistryVo.getTopicName(), routingKey, message, delayTime, callback);
    }

    public MessageResponse sendAsyncMessage(String topic, String routingKey, Object message, long delayTime, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        try {
            Message msg = new Message(topic, routingKey, SerializeCode.serialize((Object)message));
            this.sendAsync(msg, callback);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{topic, routingKey, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    public MessageResponse sendBroadcastMessage(String topic, String routingKey, Object message, long delayTime) {
        return this.sendMessage(topic, routingKey, message, delayTime);
    }

    public MessageResponse sendAsyncBroadcastMessage(String topic, String routingKey, Object message, long delayTime, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        return this.sendAsyncMessage(topic, routingKey, message, delayTime, callback);
    }

    private SendResult sendMessage(Message msg) throws Exception {
        try {
            return this.defaultMQProducer.send(msg);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{msg.getTopic(), msg.getTags(), e});
            throw e;
        }
    }

    private void sendAsync(Message msg, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        try {
            this.defaultMQProducer.send(msg, this.createMessageSendCallback(msg, callback));
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{msg.getTopic(), msg.getTags(), e});
        }
    }

    private SendCallback createMessageSendCallback(final Message msg, final com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        return new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                logger.info("\u53d1\u9001\u6d88\u606f\u6210\u529f! sendStatus is {}, msgId is: {}", (Object)sendResult.getSendStatus(), (Object)sendResult.getMsgId());
                callback.onSuccess(sendResult.getMsgId());
            }

            public void onException(Throwable e) {
                logger.info("\u53d1\u9001\u6d88\u606f\u51fa\u9519! {}", (Object)e.getMessage());
                callback.onException((Exception)e, e.getMessage());
                RetryerRegistryVo retryerRegistryVo = RocketProducer.this.getRetryerRegistryVo();
                if (retryerRegistryVo.isRetryEnable()) {
                    int times = TIMES.getAndIncrement();
                    if (times == 0 && retryerRegistryVo.getInitialSleepTimeLong() > 0L) {
                        try {
                            Thread.sleep(retryerRegistryVo.getInitialSleepTimeLong());
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        try {
                            Thread.sleep(retryerRegistryVo.getInitialSleepTimeLong() + retryerRegistryVo.getIncrementSleepTimeLong() * (long)times);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    RocketProducer.this.sendAsync(msg, callback);
                }
            }
        };
    }

    public void shutdown() {
        if (this.defaultMQProducer != null) {
            this.defaultMQProducer.shutdown();
        }
    }
}

