/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket.impl.config;

import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.RocketMessageRegistryVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.ClientConfig;

public class RocketClientConfig {
    public static ClientConfig getClientConfig(MessageRegistryVo topicInfo) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setNamesrvAddr(topicInfo.getAddressesString());
        if (topicInfo instanceof RocketMessageRegistryVo) {
            RocketMessageRegistryVo rocketConfig = (RocketMessageRegistryVo)topicInfo;
            if (StringUtils.isNotBlank((CharSequence)rocketConfig.getInstanceName())) {
                clientConfig.setInstanceName(rocketConfig.getInstanceName());
            }
            if (StringUtils.isNotBlank((CharSequence)rocketConfig.getInstanceName())) {
                clientConfig.setClientIP(rocketConfig.getClientIP());
            }
            if (0 < rocketConfig.getConsumeThreadNums()) {
                clientConfig.setClientCallbackExecutorThreads(rocketConfig.getConsumeThreadNums());
            } else {
                int availProcessors = Runtime.getRuntime().availableProcessors();
                clientConfig.setClientCallbackExecutorThreads(availProcessors);
            }
            if (null != rocketConfig.getPollNameServerInterval()) {
                clientConfig.setPollNameServerInterval(rocketConfig.getPollNameServerInterval().intValue());
            }
            if (null != rocketConfig.getHeartbeatBrokerInterval()) {
                clientConfig.setHeartbeatBrokerInterval(rocketConfig.getHeartbeatBrokerInterval().intValue());
            }
            if (null != rocketConfig.getPersistConsumerOffsetInterval()) {
                clientConfig.setPersistConsumerOffsetInterval(rocketConfig.getPersistConsumerOffsetInterval().intValue());
            }
            clientConfig.setVipChannelEnabled(rocketConfig.isVipChannelEnabled());
        }
        return clientConfig;
    }
}

