/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.mq.api.AbstractConsumer;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.rocket.impl.factory.RocketConsumerFactory;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RocketConsumer
extends AbstractConsumer {
    private static Logger logger = LoggerFactory.getLogger(RocketConsumer.class);
    private static volatile RocketConsumer single = null;
    private static final String CONSUMER_GROUP_FORMATER = "%s_%s_%s";

    private RocketConsumer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RocketConsumer getInstance() {
        if (single != null) return single;
        Class<RocketConsumer> clazz = RocketConsumer.class;
        synchronized (RocketConsumer.class) {
            single = new RocketConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public <T> MessageResponse receiveMessage(String topicName, String routingKey, IMessageProcessor<T> processor) {
        logger.info("receiveMessage,topicName:{},routingKey:{}", (Object)topicName, (Object)routingKey);
        return this.receiveMessage(topicName, this.messageRegistryVo.getConsumerId(), routingKey, processor);
    }

    public <T> MessageResponse receiveMessage(String topic, String consumer, String routingKey, IMessageProcessor<T> processor) {
        return this.toSubscribeMessage(topic, consumer, routingKey, processor, null);
    }

    public MessageResponse receiveMessage(String topicName, String consumer, Map<String, IMessageProcessor> processorMap) {
        try {
            for (Map.Entry<String, IMessageProcessor> entry : processorMap.entrySet()) {
                this.receiveMessage(topicName, consumer, entry.getKey(), entry.getValue());
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName:{},consumer:{}", new Object[]{topicName, consumer, e});
            throw new BusinessRuntimeException("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName:" + topicName + ",consumer:" + consumer, (Throwable)e);
        }
    }

    public <T> MessageResponse subscribe(String topicName, String routingKey, IMessageProcessor<T> processor) {
        return this.subscribe(topicName, this.messageRegistryVo.getConsumerId(), routingKey, processor);
    }

    public <T> MessageResponse subscribe(String topicName, String consumer, String routingKey, IMessageProcessor<T> processor) {
        logger.info("subscribe,topicName:{},consumer:{},routingKey:{}", new Object[]{topicName, consumer, routingKey});
        return this.toSubscribeMessage(topicName, consumer, routingKey, processor, MessageModel.CLUSTERING);
    }

    private <T> MessageResponse toSubscribeMessage(String topicName, String consumer, String routingKey, IMessageProcessor<T> processor, MessageModel messageModel) {
        consumer = consumer != null ? consumer : this.messageRegistryVo.getConsumerId();
        String consumerGroup = null;
        consumerGroup = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)routingKey) ? String.format(CONSUMER_GROUP_FORMATER, consumer, topicName, routingKey) : String.format(CONSUMER_GROUP_FORMATER, consumer, topicName, "ALL");
        try {
            DefaultMQPushConsumer defaultMQPushConsumer = RocketConsumerFactory.getRocketConsumer(consumerGroup, this.messageRegistryVo);
            defaultMQPushConsumer.subscribe(topicName, routingKey);
            if (messageModel != null) {
                defaultMQPushConsumer.setMessageModel(messageModel);
            } else {
                defaultMQPushConsumer.setMessageModel(MessageModel.CLUSTERING);
            }
            if (messageModel == null) {
                defaultMQPushConsumer.registerMessageListener(this.createOrderlyMessageListener(processor));
            } else {
                defaultMQPushConsumer.registerMessageListener(this.createMessageConcurrentlyListener(processor));
            }
            ServiceState serviceState = defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getServiceState();
            if (serviceState.equals((Object)ServiceState.CREATE_JUST)) {
                defaultMQPushConsumer.start();
            }
            logger.info("ConsumerStarted.");
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName:{},consumer:{},routingKey:{}", new Object[]{topicName, consumer, routingKey, e});
            throw new BusinessRuntimeException("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName:" + topicName + ",consumer:" + consumer + ",routingKey:" + routingKey, (Throwable)e);
        }
    }

    private <T> MessageListenerConcurrently createMessageConcurrentlyListener(final IMessageProcessor<T> processor) {
        return new MessageListenerConcurrently(){

            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                Object messageBody;
                MessageExt msg = msgs.get(0);
                logger.info("\u63a5\u6536\u5230\u6d88\u606f,topic={},tags={},msgId:{}", new Object[]{msg.getTopic(), msg.getTags(), msg.getMsgId()});
                try {
                    messageBody = RocketConsumer.this.unpackMessage(msg, processor);
                }
                catch (BusinessRuntimeException e) {
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
                catch (Throwable e) {
                    logger.error("unpack message failure!", e);
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
                if (processor.isDuplicationMessage(msg.getKeys(), messageBody)) {
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
                try {
                    RocketConsumer.this.addServiceContext(msg);
                    MessageResponse response = processor.process(messageBody);
                    if (!MessageResponse.SUCCESS.equals(response)) {
                        if (logger.isInfoEnabled()) {
                            logger.info("\u6d88\u606f {} \u5904\u7406\u5931\u8d25", (Object)JSON.toJSONString((Object)messageBody));
                        }
                        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("\u6d88\u606f {} \u5904\u7406\u6210\u529f", (Object)JSON.toJSONString((Object)messageBody));
                    }
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
            }
        };
    }

    private <T> Object unpackMessage(MessageExt msg, IMessageProcessor<T> processor) {
        Object messageBody;
        if (this.serializeCode.isJdkSerializer()) {
            messageBody = this.serializeCode.deSerialize(msg.getBody(), null);
        } else {
            String clazzJson = msg.getUserProperty("mqMessageBodyClassInfo");
            if (StringUtils.isEmpty((Object)clazzJson)) {
                messageBody = this.serializeCode.deSerialize(msg.getBody(), processor.getMsgType());
            } else {
                Class msgType = (Class)JacksonUtil.readValue((String)clazzJson, Class.class);
                messageBody = this.serializeCode.deSerialize(msg.getBody(), (Type)msgType);
            }
        }
        return messageBody;
    }

    private void addServiceContext(MessageExt msg) {
        Map properties = msg.getProperties();
        if (properties != null && properties.size() > 0) {
            ServiceContext serviceContext = ServiceContext.getContext();
            properties.forEach((k, v) -> {
                if (k.startsWith("_context-") && v != null) {
                    k = k.substring("_context-".length());
                    serviceContext.set(k, v);
                }
            });
        }
    }

    private <T> MessageListenerOrderly createOrderlyMessageListener(final IMessageProcessor<T> processor) {
        return new MessageListenerOrderly(){

            public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
                Object messageBody;
                context.setAutoCommit(true);
                MessageExt msg = msgs.get(0);
                logger.info("\u63a5\u6536\u5230\u6d88\u606f,topic={},tags={},msgId:{}", new Object[]{msg.getTopic(), msg.getTags(), msg.getMsgId()});
                try {
                    messageBody = RocketConsumer.this.unpackMessage(msg, processor);
                }
                catch (BusinessRuntimeException e) {
                    return ConsumeOrderlyStatus.SUCCESS;
                }
                catch (Throwable e) {
                    logger.error("unpack message failure!", e);
                    return ConsumeOrderlyStatus.SUCCESS;
                }
                String msgId = msg.getKeys();
                if (processor.isDuplicationMessage(msgId, messageBody)) {
                    logger.info("\u91cd\u590d\u6d88\u606f\uff1amsgId={}", (Object)msgId);
                    return ConsumeOrderlyStatus.SUCCESS;
                }
                try {
                    MessageResponse response;
                    Map properties = msg.getProperties();
                    if (properties != null && properties.size() > 0) {
                        ServiceContext serviceContext = ServiceContext.getContext();
                        properties.forEach((k, v) -> {
                            if (k.startsWith("_context-") && v != null) {
                                k = k.substring("_context-".length());
                                serviceContext.set(k, v);
                            }
                        });
                    }
                    if (!MessageResponse.SUCCESS.equals(response = processor.process(messageBody))) {
                        if (logger.isInfoEnabled()) {
                            logger.info("\u6d88\u606f {} \u5904\u7406\u5931\u8d25", (Object)JSON.toJSONString((Object)messageBody));
                        }
                        return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("\u6d88\u606f {} \u5904\u7406\u6210\u529f", (Object)JSON.toJSONString((Object)messageBody));
                    }
                    return ConsumeOrderlyStatus.SUCCESS;
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                }
            }
        };
    }

    public <T> MessageResponse subscribe(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        logger.info("subscribe,topicName:{},routingKeys:{}", (Object)topicName, (Object)routingKeys);
        return this.subscribe(topicName, this.getSubExpression(routingKeys), processor);
    }

    public <T> MessageResponse subscribeBroadcastMessage(String topicName, String routingKey, IMessageProcessor<T> processor) {
        return this.toSubscribeMessage(topicName, this.messageRegistryVo.getConsumerId(), routingKey, processor, MessageModel.BROADCASTING);
    }

    public <T> MessageResponse subscribeBroadcastMessage(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        return this.toSubscribeMessage(topicName, this.messageRegistryVo.getConsumerId(), this.getSubExpression(routingKeys), processor, MessageModel.BROADCASTING);
    }

    public MessageResponse unsubscribe(String topicName, String routingKey) {
        try {
            String consumer = this.messageRegistryVo.getConsumerId() != null ? this.messageRegistryVo.getConsumerId() : "";
            String consumerGroup = String.format(CONSUMER_GROUP_FORMATER, consumer, topicName, routingKey);
            DefaultMQPushConsumer defaultMQPushConsumer = RocketConsumerFactory.getRocketConsumer(consumerGroup, this.messageRegistryVo);
            defaultMQPushConsumer.unsubscribe(topicName);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u8ba2\u9605\u5931\u8d25\uff0ctopicName\uff1a{}", (Object)topicName, (Object)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }
}

