/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.mq.api.AbstractProducer;
import com.dtyunxi.huieryun.mq.api.SendCallback;
import com.dtyunxi.huieryun.mq.provider.rocket.assembler.MessageAssembler;
import com.dtyunxi.huieryun.mq.provider.rocket.impl.factory.RocketProducerFactory;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.retry.vo.RetryerRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketProducer
extends AbstractProducer {
    private static Logger logger = LoggerFactory.getLogger(RocketProducer.class);
    private static final AtomicInteger TIMES = new AtomicInteger(0);
    private static volatile RocketProducer single = null;
    private DefaultMQProducer defaultMQProducer;

    private RocketProducer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RocketProducer getInstance() {
        if (single != null) return single;
        Class<RocketProducer> clazz = RocketProducer.class;
        synchronized (RocketProducer.class) {
            if (single != null) return single;
            single = new RocketProducer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected Boolean connectMQServer() {
        try {
            this.defaultMQProducer = RocketProducerFactory.getRocketProducer(this.messageRegistryVo);
            this.defaultMQProducer.start();
            return true;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaRocket Producer\u65f6\u51fa\u9519\uff0c host:{}", (Object)this.messageRegistryVo.getHost(), (Object)e);
            return false;
        }
    }

    public MessageResponse sendSingleMessage(String topicName, String tagName, Object message, long delayTime) {
        return this.sendMessage(MQMessageVo.build((String)topicName, (String)tagName, (Object)message, (long)delayTime, (SerializeCode)this.messageRegistryVo.getSerializeCode()));
    }

    public MessageResponse sendAsyncSingleMessage(String topicName, String tagName, Object message, long delayTime, SendCallback callback) {
        return this.sendAsyncMessage(MQMessageVo.build((String)topicName, (String)tagName, (Object)message, (long)delayTime, (SerializeCode)this.messageRegistryVo.getSerializeCode()), callback);
    }

    public MessageResponse sendMessage(String topicName, String tagName, Object message, long delayTime) {
        return this.sendMessage(MQMessageVo.build((String)topicName, (String)tagName, (Object)message, (long)delayTime, (SerializeCode)this.messageRegistryVo.getSerializeCode()));
    }

    public MessageResponse sendAsyncMessage(String tagName, Object message, SendCallback callback) {
        return this.sendAsyncMessage(MQMessageVo.build((String)this.messageRegistryVo.getTopicName(), (String)tagName, (Object)message, (SerializeCode)this.messageRegistryVo.getSerializeCode()), callback);
    }

    public MessageResponse sendAsyncMessage(String tagName, Object message, long delayTime, SendCallback callback) {
        return this.sendAsyncMessage(MQMessageVo.build((String)this.messageRegistryVo.getTopicName(), (String)tagName, (Object)message, (long)delayTime, (SerializeCode)this.messageRegistryVo.getSerializeCode()), callback);
    }

    public MessageResponse sendAsyncMessage(String topicName, String tagName, Object message, long delayTime, SendCallback callback) {
        return this.sendAsyncMessage(MQMessageVo.build((String)topicName, (String)tagName, (Object)message, (long)delayTime, (SerializeCode)this.messageRegistryVo.getSerializeCode()), callback);
    }

    public MessageResponse sendBroadcastMessage(String topicName, String tagName, Object message, long delayTime) {
        return this.sendMessage(MQMessageVo.build((String)topicName, (String)tagName, (Object)message, (long)delayTime, (SerializeCode)this.messageRegistryVo.getSerializeCode()));
    }

    public MessageResponse sendAsyncBroadcastMessage(String topicName, String tagName, Object message, long delayTime, SendCallback callback) {
        return this.sendAsyncMessage(MQMessageVo.build((String)topicName, (String)tagName, (Object)message, (long)delayTime, (SerializeCode)this.messageRegistryVo.getSerializeCode()), callback);
    }

    private SendResult sendMessage(Message msg) throws Exception {
        try {
            this.addServiceContext(msg);
            return this.defaultMQProducer.send(msg);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} tagName:{}", new Object[]{msg.getTopic(), msg.getTags(), e});
            throw e;
        }
    }

    private void addServiceContext(Message msg) {
        if (!this.messageRegistryVo.isPassSvcContext()) {
            return;
        }
        ServiceContext.getContext().getKeys().forEach((k, v) -> {
            if (k != null && v != null) {
                msg.putUserProperty("_context-" + k, v.toString());
            }
        });
    }

    private void sendAsync(Message msg, SendCallback callback) {
        try {
            this.addServiceContext(msg);
            this.defaultMQProducer.send(msg, this.createMessageSendCallback(msg, callback));
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} tagName:{}", new Object[]{msg.getTopic(), msg.getTags(), e});
        }
    }

    private org.apache.rocketmq.client.producer.SendCallback createMessageSendCallback(final Message msg, final SendCallback callback) {
        return new org.apache.rocketmq.client.producer.SendCallback(){

            public void onSuccess(SendResult sendResult) {
                logger.info("\u53d1\u9001\u6d88\u606f\u6210\u529f! sendStatus is {}, msgId is: {}", (Object)sendResult.getSendStatus(), (Object)sendResult.getMsgId());
                callback.onSuccess(sendResult.getMsgId());
            }

            public void onException(Throwable e) {
                logger.info("\u53d1\u9001\u6d88\u606f\u51fa\u9519! {}", (Object)e.getMessage());
                callback.onException((Exception)e, e.getMessage());
                RetryerRegistryVo retryerRegistryVo = RocketProducer.this.getRetryerRegistryVo();
                if (retryerRegistryVo.isRetryEnable()) {
                    int times = TIMES.getAndIncrement();
                    if (times == 0 && retryerRegistryVo.getInitialSleepTimeLong() > 0L) {
                        try {
                            Thread.sleep(retryerRegistryVo.getInitialSleepTimeLong());
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        try {
                            Thread.sleep(retryerRegistryVo.getInitialSleepTimeLong() + retryerRegistryVo.getIncrementSleepTimeLong() * (long)times);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    RocketProducer.this.sendAsync(msg, callback);
                }
            }
        };
    }

    public MessageResponse sendMessage(MQMessageVo messageVo) {
        try {
            Message message = MessageAssembler.messageVoToMessage(messageVo);
            SendResult result = this.sendMessage(message);
            return new MessageResponse((Object)result.getMsgId());
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} tagName:{}", new Object[]{messageVo.getTopic(), messageVo.getTag(), e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    public MessageResponse sendAsyncMessage(MQMessageVo messageVo, SendCallback callback) {
        try {
            Message message = MessageAssembler.messageVoToMessage(messageVo);
            this.sendAsync(message, callback);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} tagName:{}", new Object[]{messageVo.getTopic(), messageVo.getTag(), e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    public void shutdown() {
        if (this.defaultMQProducer != null) {
            this.defaultMQProducer.shutdown();
        }
    }
}

