/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket.impl.factory;

import com.dtyunxi.huieryun.mq.provider.rocket.impl.config.RocketClientConfig;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.RocketMessageRegistryVo;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketProducerFactory {
    private static final Logger logger = LoggerFactory.getLogger(RocketProducerFactory.class);

    public static DefaultMQProducer getRocketProducer(MessageRegistryVo messageRegistryVo) {
        DefaultMQProducer producer = new DefaultMQProducer();
        producer.setVipChannelEnabled(false);
        RocketProducerFactory.restConfig(messageRegistryVo, producer);
        if (logger.isDebugEnabled()) {
            logger.debug("create rocket producer success,{}", (Object)producer);
        }
        return producer;
    }

    private static void restConfig(MessageRegistryVo messageRegistryVo, DefaultMQProducer producer) {
        producer.setVipChannelEnabled(false);
        producer.resetClientConfig(RocketClientConfig.getClientConfig(messageRegistryVo));
        if (messageRegistryVo instanceof RocketMessageRegistryVo) {
            RocketMessageRegistryVo rocketConfig = (RocketMessageRegistryVo)messageRegistryVo;
            if (rocketConfig.getTopicQueueNums() > 0) {
                producer.setDefaultTopicQueueNums(rocketConfig.getTopicQueueNums());
            }
            if (rocketConfig.getSendMsgTimeout() >= 0) {
                producer.setSendMsgTimeout(rocketConfig.getSendMsgTimeout());
            }
            if (rocketConfig.getCompressMsgBodyOverHowmuch() > 0) {
                producer.setCompressMsgBodyOverHowmuch(rocketConfig.getCompressMsgBodyOverHowmuch());
            }
            producer.setRetryAnotherBrokerWhenNotStoreOK(rocketConfig.isRetryAnotherBrokerWhenNotStoreOK());
            if (rocketConfig.getRetryTimesWhenSendAsyncFailed() >= 0) {
                producer.setRetryTimesWhenSendAsyncFailed(rocketConfig.getRetryTimesWhenSendAsyncFailed());
            }
            if (rocketConfig.getRetryTimesWhenSendFailed() >= 0) {
                producer.setRetryTimesWhenSendFailed(rocketConfig.getRetryTimesWhenSendFailed());
            }
        }
        producer.setProducerGroup(messageRegistryVo.getProducerId());
    }
}

