/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket.impl.factory;

import com.dtyunxi.huieryun.mq.provider.rocket.impl.config.RocketClientConfig;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketConsumerFactory {
    private static final Logger logger = LoggerFactory.getLogger(RocketConsumerFactory.class);
    private static final ConcurrentHashMap<String, DefaultMQPushConsumer> consumerMap = new ConcurrentHashMap();

    public static DefaultMQPushConsumer getRocketConsumer(String consumerGroup, MessageRegistryVo messageRegistryVo) {
        if (consumerMap.get(consumerGroup) == null) {
            DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(consumerGroup);
            consumer.resetClientConfig(RocketClientConfig.getClientConfig(messageRegistryVo));
            logger.info("create rocket consumer success,{}", (Object)consumer);
            consumerMap.put(consumerGroup, consumer);
            return consumer;
        }
        return consumerMap.get(consumerGroup);
    }
}

