/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.mq.runner;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.IMQConsumerRegister;
import com.dtyunxi.cube.plugin.mq.MQProcessorRegisterDto;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.util.CollectionUtils;

public final class MQRegisterRunner
implements CommandLineRunner {
    private static Logger logger = LoggerFactory.getLogger(MQRegisterRunner.class);
    private List<IMQConsumerRegister> consumerRegisterList;
    private final ICommonsMqService commonsMqService;

    public MQRegisterRunner(ICommonsMqService commonsMqService, List<IMQConsumerRegister> consumerRegisterList) {
        this.commonsMqService = commonsMqService;
        this.consumerRegisterList = consumerRegisterList;
    }

    public void run(String ... args) throws Exception {
        if (CollectionUtils.isEmpty(this.consumerRegisterList)) {
            logger.warn("\u6ca1\u6709\u4efb\u4f55\u6d88\u8d39\u8005\u6ce8\u518c\uff01");
            return;
        }
        for (IMQConsumerRegister mqRegisterService : this.consumerRegisterList) {
            List<MQProcessorRegisterDto> MQProcessorRegisterDtoList = mqRegisterService.getMQProcessorRegisters();
            if (CollectionUtils.isEmpty(MQProcessorRegisterDtoList)) continue;
            for (MQProcessorRegisterDto mqProcessorRegisterDto : MQProcessorRegisterDtoList) {
                CommonsMqHelper.addProcessor(mqProcessorRegisterDto.getTopic(), mqProcessorRegisterDto.getConsumer(), mqProcessorRegisterDto.getTag(), mqProcessorRegisterDto.getMsgType(), mqProcessorRegisterDto.getBean());
            }
        }
        Set<String> consumers = CommonsMqHelper.processMap.keySet();
        if (!consumers.isEmpty()) {
            consumers.forEach(consumer -> {
                this.commonsMqService.start((String)consumer);
                logger.info("\u5f00\u59cb\u76d1\u542c\uff1aconsumer: {}, processors:{}", consumer, (Object)JSON.toJSONString(CommonsMqHelper.processMap.get(consumer)));
            });
        }
    }

    public ICommonsMqService getCommonsMqService() {
        return this.commonsMqService;
    }
}

