/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.base;

import com.dtyunxi.huieryun.mq.das.MqLogDas;
import com.dtyunxi.huieryun.mq.eo.MqLogEo;
import com.dtyunxi.huieryun.mq.provider.base.MqLogConfig;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.RabbitMqManager;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.rabbitmq.client.ConnectionFactory;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BaseService {
    private static Logger logger = LoggerFactory.getLogger(BaseService.class);
    protected ScheduledExecutorService executor;
    protected MessageRegistryVo messageRegistryVo;
    protected boolean durable = true;
    protected int prefetchCount = 1;
    protected boolean autoAck = false;

    protected void saveMqLog(String topicName, String queueName, String routingKey, Object message, Integer sendType, String failReason, String className, String remark) {
        MqLogDas mqLogDas = this.getMqLogDas();
        if (mqLogDas != null) {
            MqLogEo mqLogEo = new MqLogEo();
            mqLogEo.setMqTopic(topicName);
            mqLogEo.setMqQueue(queueName);
            mqLogEo.setMqRoutingKey(routingKey);
            mqLogEo.setMqMessage(JacksonUtil.toJson((Object)message));
            mqLogEo.setMqSendType(sendType);
            mqLogEo.setFailReason(failReason);
            mqLogEo.setClassName(className);
            mqLogEo.setRemark(remark);
            mqLogDas.insert(mqLogEo);
        }
    }

    protected MqLogDas getMqLogDas() {
        MqLogDas mqLogDas = (MqLogDas)MqLogConfig.getInstance().getBean("mqLogDas");
        if (null == mqLogDas) {
            try {
                mqLogDas = (MqLogDas)SpringBeanUtil.getBean((String)"mqLogDas");
                MqLogConfig.getInstance().addBean("mqLogDas", mqLogDas);
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316MqLogDas bean\u5931\u8d25");
            }
        }
        return mqLogDas;
    }

    protected Properties getProperties(MessageRegistryVo messageRegistryVo) {
        Properties properties = new Properties();
        properties.setProperty("AccessKey", messageRegistryVo.getUsername());
        properties.setProperty("SecretKey", messageRegistryVo.getPassword());
        return properties;
    }

    protected RabbitMqManager connectRabbitMqManager(MessageRegistryVo messageRegistryVo) {
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            if (messageRegistryVo.getAddresses() == null) {
                connectionFactory.setUri(messageRegistryVo.getHost());
                connectionFactory.setPort(Integer.parseInt(messageRegistryVo.getPort()));
            }
            connectionFactory.setUsername(messageRegistryVo.getUsername());
            connectionFactory.setPassword(messageRegistryVo.getPassword());
            connectionFactory.setVirtualHost(messageRegistryVo.getVirtualHost());
            ExecutorService service = Executors.newFixedThreadPool(messageRegistryVo.getConsumeThreadNums());
            connectionFactory.setSharedExecutor(service);
            connectionFactory.setConnectionTimeout(30000);
            connectionFactory.setAutomaticRecoveryEnabled(true);
            connectionFactory.setTopologyRecoveryEnabled(true);
            connectionFactory.setNetworkRecoveryInterval(10000);
            connectionFactory.setRequestedHeartbeat(360);
            RabbitMqManager rabbitMqManager = new RabbitMqManager(connectionFactory, messageRegistryVo.getAddresses());
            rabbitMqManager.start();
            return rabbitMqManager;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaRabbitMQ\u6d88\u606f\u8fde\u63a5\u51fa\u9519: {}", (Object)messageRegistryVo);
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    protected void start(MessageRegistryVo messageRegistryVo) {
    }

    protected void asyncWaitAndReconnect(final MessageRegistryVo messageRegistryVo) {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                BaseService.this.start(messageRegistryVo);
            }
        }, 30L, TimeUnit.SECONDS);
    }

    protected String getTopicName() {
        return this.messageRegistryVo.getTopicName() == null ? "default.topic.exchange" : this.messageRegistryVo.getTopicName();
    }

    protected String getDirectName() {
        return this.messageRegistryVo.getTopicName() == null ? "default.direct.exchange" : this.messageRegistryVo.getTopicName();
    }

    public void setMessageRegistryVo(MessageRegistryVo messageRegistryVo) {
        this.messageRegistryVo = messageRegistryVo;
    }

    protected int getWaiTime(int retryCount) {
        int waitTime = 0;
        switch (retryCount) {
            case 1: {
                waitTime = retryCount * 30;
                break;
            }
            case 2: {
                waitTime = retryCount * 60;
                break;
            }
            case 3: {
                waitTime = retryCount * 100;
                break;
            }
            case 4: {
                waitTime = retryCount * 150;
                break;
            }
            case 5: {
                waitTime = retryCount * 240;
                break;
            }
            case 6: {
                waitTime = retryCount * 400;
                break;
            }
            case 7: {
                waitTime = retryCount * 500;
                break;
            }
            case 8: {
                waitTime = retryCount * 600;
                break;
            }
            case 9: {
                waitTime = retryCount * 700;
                break;
            }
        }
        return waitTime;
    }

    protected String getMessageId() {
        return UUID.randomUUID().toString();
    }
}

