/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit.impl;

import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.base.BaseService;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.Subscription;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMqManager
extends BaseService
implements ShutdownListener {
    private static Logger logger = LoggerFactory.getLogger(RabbitMqManager.class);
    protected final ConnectionFactory factory;
    protected final ScheduledExecutorService executor;
    protected volatile Connection connection;
    protected Address[] HOST_ARRAY;
    protected int retryCount = 0;

    public RabbitMqManager(ConnectionFactory factory, String[] addresses) {
        this.factory = factory;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.connection = null;
        this.initAddress(addresses);
    }

    public void start() {
        try {
            if (this.HOST_ARRAY == null) {
                this.connection = this.factory.newConnection();
                logger.info("Connected to {} : {}", (Object)this.factory.getHost(), (Object)this.factory.getPort());
            } else {
                this.connection = this.factory.newConnection(this.HOST_ARRAY);
                logger.info("Connected to:{}", (Object[])this.HOST_ARRAY);
            }
            this.connection.addShutdownListener((ShutdownListener)this);
            this.retryCount = 0;
            logger.info("--------\u83b7\u53d6MQ\u8fde\u63a5\u6210\u529f---------");
        }
        catch (Exception e) {
            if (this.HOST_ARRAY == null) {
                logger.error("\u83b7\u53d6mq\u8fde\u63a5\u5931\u8d25:{}", new Object[]{this.factory.getHost(), this.factory.getPort(), e});
            } else {
                logger.error("\u83b7\u53d6mq\u8fde\u63a5\u5931\u8d25:{}", (Object)this.HOST_ARRAY, (Object)e);
            }
            logger.info("-------\u83b7\u53d6mq\u8fde\u63a5\u5931\u8d25,\u8fdb\u884c\u91cd\u8fde\u64cd\u4f5c-------");
            this.stop();
            this.asyncWaitAndReconnect();
        }
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        if (!cause.isInitiatedByApplication()) {
            if (this.HOST_ARRAY == null) {
                logger.info("Lost connection to {} : {}", new Object[]{this.factory.getHost(), this.factory.getPort(), cause});
            } else {
                logger.info("Lost connection to:{}", (Object)this.HOST_ARRAY, (Object)cause);
            }
            this.stop();
            this.asyncWaitAndReconnect();
        }
    }

    protected void asyncWaitAndReconnect() {
        ++this.retryCount;
        int waitTime = this.getWaiTime(this.retryCount);
        logger.info("\u7b49\u5f85{}\u79d2\u540e\u518d\u6b21\u83b7\u53d6MQ\u8fde\u63a5\u8bf7\u6c42\u64cd\u4f5c", (Object)waitTime);
        if (this.retryCount < 10) {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    RabbitMqManager.this.start();
                }
            }, (long)waitTime, TimeUnit.SECONDS);
        } else if (!this.executor.isShutdown()) {
            logger.info("-----10\u6b21\u91cd\u8bd5\u64cd\u4f5c\u540e\u5931\u8d25\uff0c\u5c06\u4e0d\u5728\u8fdb\u884c\u91cd\u8bd5\u8bf7\u6c42------");
            this.executor.shutdownNow();
        }
    }

    public void stop() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (Exception e) {
            logger.error("Failed to close connection", (Throwable)e);
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
        finally {
            this.connection = null;
        }
    }

    public Channel createChannel() {
        try {
            return this.connection == null ? null : this.connection.createChannel();
        }
        catch (Exception e) {
            logger.error("Failed to create channel", (Throwable)e);
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    public void closeChannel(Channel channel) {
        if (channel == null || !channel.isOpen()) {
            return;
        }
        try {
            channel.close();
        }
        catch (Exception e) {
            logger.error("Failed to close channel:{}", (Object)channel, (Object)e);
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    public <T> Subscription createSubscription(String exchange, String routingKey, IMessageProcessor<T> handler) {
        return new Subscription(exchange, routingKey, handler);
    }

    public <T> Subscription createSubscription(String exchange, String[] routingKeys, IMessageProcessor<T> handler) {
        return new Subscription(exchange, routingKeys, handler);
    }

    private void initAddress(String[] addresses) {
        if (addresses != null) {
            this.HOST_ARRAY = new Address[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                String[] addr = addresses[i].split(":");
                logger.info("address to host:{}, port:{}", (Object)addr[0], (Object)addr[1]);
                this.HOST_ARRAY[i] = new Address(addr[0], Integer.parseInt(addr[1]));
            }
        }
    }
}

