/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket;

import com.dtyunxi.huieryun.mq.api.AbstractProducer;
import com.dtyunxi.huieryun.mq.api.MQConstants;
import com.dtyunxi.huieryun.mq.provider.rocket.impl.factory.RocketProducerFactory;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketProducer
extends AbstractProducer {
    private static Logger logger = LoggerFactory.getLogger(RocketProducer.class);
    private static volatile RocketProducer single = null;
    private DefaultMQProducer defaultMQProducer;

    private RocketProducer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RocketProducer getInstance() {
        if (single != null) return single;
        Class<RocketProducer> clazz = RocketProducer.class;
        synchronized (RocketProducer.class) {
            if (single != null) return single;
            single = new RocketProducer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public void createProducer(MessageRegistryVo topicInfo) {
        this.messageRegistryVo = topicInfo;
        this.start(topicInfo);
    }

    @Override
    protected void start(MessageRegistryVo messageRegistryVo) {
        try {
            this.defaultMQProducer = RocketProducerFactory.getRocketProducer(messageRegistryVo);
            this.defaultMQProducer.start();
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaRocket Producer\u65f6\u51fa\u9519\uff0c host:{}", (Object)messageRegistryVo.getHost(), (Object)e);
            this.asyncWaitAndReconnect(messageRegistryVo);
        }
    }

    @Override
    public MessageResponse sendSingleMessage(String topicName, String queueName, Object message, long delayTime) {
        return this.sendMessage(topicName, queueName, message, delayTime);
    }

    @Override
    public MessageResponse sendAsyncSingleMessage(String topic, String queueName, Object message, long delayTime, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        return this.sendAsyncMessage(topic, queueName, message, delayTime, callback);
    }

    @Override
    public MessageResponse sendMessage(String topicName, String routingKey, Object message, long delayTime) {
        try {
            Message msg = new Message(topicName, routingKey, SerializeCode.serialize(message));
            if (delayTime > 0L) {
                msg.setDelayTimeLevel(2);
            }
            SendResult result = this.defaultMQProducer.send(msg);
            return new MessageResponse(result.getMsgId());
        }
        catch (Exception e) {
            this.saveMqLog(topicName, null, routingKey, message, MQConstants.MQ_SEDN_TYPE_PUB, e.getMessage(), message.getClass().getName(), "sendMessage");
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{this.messageRegistryVo.getTopicName(), routingKey, e});
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    @Override
    public MessageResponse sendAsyncMessage(String routingKey, Object message, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        return this.sendAsyncMessage(this.messageRegistryVo.getTopicName(), routingKey, message, 0L, callback);
    }

    @Override
    public MessageResponse sendAsyncMessage(String routingKey, Object message, long delayTime, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        return this.sendAsyncMessage(this.messageRegistryVo.getTopicName(), routingKey, message, delayTime, callback);
    }

    @Override
    public MessageResponse sendAsyncMessage(String topic, String routingKey, Object message, long delayTime, com.dtyunxi.huieryun.mq.api.SendCallback callback) {
        try {
            Message msg = new Message(topic, routingKey, SerializeCode.serialize(message));
            this.sendAsync(msg, callback);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{this.messageRegistryVo.getTopicName(), routingKey, e});
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    private void sendAsync(Message msg, final com.dtyunxi.huieryun.mq.api.SendCallback callback) throws Exception {
        this.defaultMQProducer.send(msg, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                logger.info("\u53d1\u9001\u6d88\u606f\u6210\u529f! sendStatus is {}, msgId is: {}", (Object)sendResult.getSendStatus(), (Object)sendResult.getMsgId());
                callback.onSuccess(sendResult.getMsgId());
            }

            public void onException(Throwable e) {
                logger.info("\u53d1\u9001\u6d88\u606f\u51fa\u9519! {}", (Object)e.getMessage());
                callback.onException((Exception)e, e.getMessage());
            }
        });
    }
}

