/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket.impl.factory;

import com.dtyunxi.huieryun.mq.provider.rocket.impl.config.RocketClientConfig;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketConsumerFactory {
    private static Logger logger = LoggerFactory.getLogger(RocketConsumerFactory.class);
    public static ConcurrentHashMap<String, DefaultMQPushConsumer> consumerMap = new ConcurrentHashMap();

    public static void initConsumer(MessageRegistryVo topicInfo) {
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(topicInfo.getTopicName());
        RocketConsumerFactory.restConfig(topicInfo, consumer);
        logger.info("create rocket consumer success,{}", (Object)consumer);
        consumerMap.put(topicInfo.getTopicName(), consumer);
    }

    public static DefaultMQPushConsumer getRocketConsumer(MessageRegistryVo topicInfo) {
        if (consumerMap.get(topicInfo.getTopicName()) == null) {
            RocketConsumerFactory.initConsumer(topicInfo);
        }
        return consumerMap.get(topicInfo.getTopicName());
    }

    private static void restConfig(MessageRegistryVo topicInfo, DefaultMQPushConsumer consumer) {
        consumer.resetClientConfig(RocketClientConfig.getClientConfig(topicInfo));
        consumer.setConsumerGroup(StringUtils.isNotEmpty((CharSequence)topicInfo.getGroupName()) ? topicInfo.getGroupName() : topicInfo.getTopicName());
    }
}

