/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider.aws;

import com.dtyunxi.huieryun.oss.provider.minio.MinioObjectStorage;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import io.minio.MinioClient;
import java.util.Map;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class AmazonS3ObjectStorage
extends MinioObjectStorage {
    public void init(OssRegistryVo ossRegistryVo, ThreadPoolTaskExecutor threadPool) {
        this.threadPool = threadPool;
        this.ossRegistryVo = ossRegistryVo;
        String endpoint = ossRegistryVo.getEndpoint();
        boolean customDomain = endpoint.startsWith("https://" + ossRegistryVo.getBucketName());
        if (customDomain) {
            endpoint = endpoint.replaceAll("https://" + ossRegistryVo.getBucketName() + ".", "https://");
        }
        this.minioClient = MinioClient.builder().endpoint(endpoint).credentials(ossRegistryVo.getAccessKeyId(), ossRegistryVo.getAccessKeySecret()).region(ossRegistryVo.getRegionName()).build();
        this.minioClient.enableVirtualStyleEndpoint();
    }

    public Map<String, String> createPolicy(OssRegistryVo ossRegistryVo, String fileType) {
        Map formData = super.createPolicy(ossRegistryVo, fileType);
        if (formData == null) {
            return null;
        }
        String formAction = ossRegistryVo.getEndpoint();
        boolean customDomain = formAction.startsWith("https://" + ossRegistryVo.getBucketName());
        formAction = customDomain ? formAction + "/" : formAction + "/" + ossRegistryVo.getBucketName();
        formData.put("form-action", formAction);
        return formData;
    }
}

