/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider.minio;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.api.IObjectInputStreamProcessor;
import com.dtyunxi.huieryun.oss.provider.domain.TempSignCreateParam;
import com.dtyunxi.huieryun.oss.util.FileContentTypeUtil;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import io.minio.AwsPostPolicy;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PostPolicy;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.http.Method;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

public class MinioObjectStorage
extends AbstractObjectStorageService {
    protected static final Logger logger = LoggerFactory.getLogger(MinioObjectStorage.class);
    protected static final String BACKSLASH = "/";
    protected MinioClient minioClient = null;

    public void init(OssRegistryVo ossRegistryVo, ThreadPoolTaskExecutor threadPool) {
        this.threadPool = threadPool;
        this.ossRegistryVo = ossRegistryVo;
        this.minioClient = MinioClient.builder().endpoint(ossRegistryVo.getEndpoint()).credentials(ossRegistryVo.getAccessKeyId(), ossRegistryVo.getAccessKeySecret()).build();
        try {
            this.makeBucket(ossRegistryVo.getBucketName());
        }
        catch (Exception e) {
            logger.warn("makeBucket fail", (Throwable)e);
        }
    }

    public String put(String bucketName, String objectName, InputStream inputstream) {
        String fileURI = this.getSaveFilePath(objectName);
        if (StrUtil.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        String contentType = FileContentTypeUtil.getType((String)objectName);
        try {
            PutObjectArgs.Builder builder = PutObjectArgs.builder();
            if (contentType != null) {
                builder.contentType(contentType);
            }
            PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)builder.bucket(bucketName)).object(fileURI)).stream(inputstream, Long.valueOf(inputstream.available()).longValue(), -1L).build();
            this.minioClient.putObject(putObjectArgs);
            String endpoint = this.ossRegistryVo.getEndpoint();
            boolean customDomain = endpoint.startsWith("https://" + bucketName);
            if (customDomain) {
                return endpoint + BACKSLASH + fileURI;
            }
            return endpoint + BACKSLASH + bucketName + BACKSLASH + fileURI;
        }
        catch (Exception e) {
            logger.warn("put fail", (Throwable)e);
            return null;
        }
    }

    public void delete(String bucketName, String objectName) {
        if (StrUtil.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(this.getObjectName(objectName))).build());
        }
        catch (Exception e) {
            logger.warn("delete fail", (Throwable)e);
        }
    }

    public boolean exists(String bucketName, String objectName) {
        if (StrUtil.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        try {
            return null != this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(this.getObjectName(objectName))).build());
        }
        catch (Exception e) {
            logger.warn("exists fail", (Throwable)e);
            return false;
        }
    }

    public Map<String, String> createPolicy() {
        return this.createPolicy(this.ossRegistryVo);
    }

    public Map<String, String> createPolicy(String fileType) {
        return this.createPolicy(this.ossRegistryVo, fileType);
    }

    public Map<String, String> createPolicy(OssRegistryVo ossRegistryVo) {
        return this.createPolicy(ossRegistryVo, null);
    }

    public Map<String, String> createPolicy(OssRegistryVo ossRegistryVo, String fileType) {
        try {
            AwsPostPolicy policy = new AwsPostPolicy(ossRegistryVo.getBucketName(), ZonedDateTime.now().plusHours(ossRegistryVo.getExpireHour()));
            if (StringUtils.hasText((String)ossRegistryVo.getDir())) {
                policy.addStartsWithCondition("key", ossRegistryVo.getDir());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fileType)) {
                policy.addStartsWithCondition("Content-Type", fileType);
            }
            policy.addEqualsCondition("acl", ossRegistryVo.getAcl());
            String formAction = ossRegistryVo.getEndpoint() + BACKSLASH + ossRegistryVo.getBucketName();
            Map formData = this.minioClient.getPresignedPostFormData((PostPolicy)policy);
            formData.put("form-action", formAction);
            formData.remove("bucket");
            return formData;
        }
        catch (Exception e) {
            logger.error("creat poliy fail", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream get(String fileURI) {
        InputStream stream = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int length;
            stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.ossRegistryVo.getBucketName())).object(this.getObjectName(fileURI))).build());
            byte[] buf = new byte[16384];
            while ((length = stream.read(buf, 0, buf.length)) >= 0) {
                out.write(buf, 0, length);
            }
            ByteArrayOutputStream byteArrayOutputStream = out;
            return byteArrayOutputStream;
        }
        catch (Exception e) {
            logger.error("get by fileURI={}", (Object)fileURI, (Object)e);
        }
        finally {
            try {
                if (null != stream) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private String getObjectName(String fileURI) {
        String objectName = fileURI;
        if (objectName.startsWith(this.ossRegistryVo.getEndpoint())) {
            objectName = objectName.substring(this.ossRegistryVo.getEndpoint().length() + 1);
        }
        if (objectName.startsWith(this.ossRegistryVo.getBucketName())) {
            objectName = objectName.substring(this.ossRegistryVo.getBucketName().length() + 1);
        }
        if (objectName.startsWith(BACKSLASH)) {
            objectName = objectName.substring(1);
        }
        if (objectName.startsWith(this.ossRegistryVo.getDir())) {
            return objectName;
        }
        return this.ossRegistryVo.getDir() + objectName;
    }

    public Map<String, String> createGetFileSignerHeader(String fileURI) {
        try {
            PostPolicy policy = new PostPolicy(this.ossRegistryVo.getBucketName(), ZonedDateTime.now().plusHours(this.ossRegistryVo.getExpireHour()));
            policy.addEqualsCondition("key", this.getObjectName(fileURI));
            return this.minioClient.getPresignedPostFormData(policy);
        }
        catch (Exception e) {
            logger.error("create get file signerHeader fail", (Throwable)e);
            return null;
        }
    }

    public String getFileUrlWithQureyParamter(String fileURI, int expiresIn) {
        try {
            String objectName = this.getObjectName(fileURI);
            GetPresignedObjectUrlArgs presignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(this.ossRegistryVo.getBucketName())).object(objectName)).expiry(expiresIn, TimeUnit.HOURS).build();
            return this.minioClient.getPresignedObjectUrl(presignedObjectUrlArgs);
        }
        catch (Exception e) {
            logger.error("get file url with qurey paramter fail", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream get(String objectName, String bucketName) {
        if (StrUtil.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            GetObjectResponse inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(this.getObjectName(objectName))).build());
            IoUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            ByteArrayOutputStream byteArrayOutputStream = outputStream;
            return byteArrayOutputStream;
        }
        catch (Exception e) {
            logger.error("get object fail", (Throwable)e);
        }
        finally {
            try {
                if (null != outputStream) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String objectName, String bucketName, IObjectInputStreamProcessor processor) {
        if (StrUtil.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        InputStream inputStream = null;
        try {
            inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(this.getObjectName(objectName))).build());
            processor.process(inputStream);
        }
        catch (Throwable e) {
            logger.error("get object fail", e);
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void makeBucket(String bucketName) throws Exception {
        boolean isExist = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        if (!isExist) {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public Map<String, String> createSts(OssRegistryVo registryVo, TempSignCreateParam tempSignCreateParam) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    public Logger getLogger() {
        return logger;
    }
}

