/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider;

import cn.hutool.core.io.IoUtil;
import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.provider.AliyunObjectStorage;
import com.dtyunxi.huieryun.oss.provider.domain.TempSignCreateParam;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import io.minio.AwsPostPolicy;
import io.minio.MinioClient;
import io.minio.PostPolicy;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidArgumentException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidExpiresRangeException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.NoResponseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class MinioObjectStorage
extends AbstractObjectStorageService {
    private static final Logger logger = LoggerFactory.getLogger(AliyunObjectStorage.class);
    private static final String BACKSLASH = "/";
    private MinioClient minioClient = null;

    @Override
    public void init(OssRegistryVo ossRegistryVo) {
        this.ossRegistryVo = ossRegistryVo;
        try {
            String endpoint = ossRegistryVo.getEndpoint();
            String accessKey = ossRegistryVo.getAccessKeyId();
            String secretKey = ossRegistryVo.getAccessKeySecret();
            this.minioClient = new MinioClient(endpoint, accessKey, secretKey);
            this.makeBucket(ossRegistryVo.getBucketName());
        }
        catch (InvalidEndpointException e) {
            logger.warn("endPoint is not available", (Throwable)e);
        }
        catch (InvalidPortException e) {
            logger.warn("port is not available", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("init fail", (Throwable)e);
        }
    }

    @Override
    public String put(String bucketName, String objectName, InputStream inputstream) {
        try {
            this.minioClient.putObject(bucketName, objectName, inputstream, Long.valueOf(inputstream.available()), null, null, null);
            return this.minioClient.getObjectUrl(bucketName, objectName);
        }
        catch (Exception e) {
            logger.warn("put fail", (Throwable)e);
            return null;
        }
    }

    @Override
    public String put(String group, String key, String fileUrl) {
        return this.put(group, key, IoUtil.toStream((File)new File(fileUrl)));
    }

    @Override
    public void delete(String group, String key) {
        try {
            this.minioClient.removeObject(group, key);
        }
        catch (Exception e) {
            logger.warn("delete fail", (Throwable)e);
        }
    }

    @Override
    public boolean exists(String group, String key) {
        try {
            return null != this.minioClient.getObjectUrl(group, key);
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            logger.warn("exists fail", e);
            return false;
        }
    }

    @Override
    public Map<String, String> creatPoliy() {
        return this.creatPoliy(this.ossRegistryVo);
    }

    @Override
    public Map<String, String> creatPoliy(String fileType) {
        return this.creatPoliy(this.ossRegistryVo, fileType);
    }

    @Override
    public Map<String, String> creatPoliy(OssRegistryVo ossRegistryVo) {
        return this.creatPoliy(ossRegistryVo, null);
    }

    @Override
    public Map<String, String> creatPoliy(OssRegistryVo ossRegistryVo, String fileType) {
        try {
            AwsPostPolicy policy = new AwsPostPolicy(ossRegistryVo.getBucketName(), ossRegistryVo.getDir(), true, DateTime.now().plusHours(ossRegistryVo.getExpireHour()));
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                policy.setContentType(fileType);
            }
            String formAction = ossRegistryVo.getEndpoint() + BACKSLASH + ossRegistryVo.getBucketName();
            Map formData = this.minioClient.presignedPostPolicy((PostPolicy)policy);
            formData.put("form-action", formAction);
            formData.remove("bucket");
            return formData;
        }
        catch (Exception e) {
            logger.error("creat poliy fail", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream get(String fileURI) {
        InputStream stream = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int length;
            stream = this.minioClient.getObject(this.ossRegistryVo.getBucketName(), fileURI);
            byte[] buf = new byte[16384];
            while ((length = stream.read(buf, 0, buf.length)) >= 0) {
                out.write(buf, 0, length);
            }
            ByteArrayOutputStream byteArrayOutputStream = out;
            return byteArrayOutputStream;
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidArgumentException | InvalidBucketNameException | InvalidResponseException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            logger.error("get by fileURI={}", (Object)fileURI, (Object)e);
        }
        finally {
            try {
                if (null != stream) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    @Override
    public Map<String, String> createGetFileSignerHeader(String fileURI) {
        try {
            PostPolicy policy = new PostPolicy(this.ossRegistryVo.getBucketName(), fileURI, DateTime.now().plusHours(this.ossRegistryVo.getExpireHour()));
            return this.minioClient.presignedPostPolicy(policy);
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidArgumentException | InvalidBucketNameException | InvalidResponseException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            logger.error("create get file signerHeader fail", e);
            return null;
        }
    }

    @Override
    public String getFileUrlWithQureyParamter(String fileURI, int expiresIn) {
        try {
            return this.minioClient.presignedGetObject(this.ossRegistryVo.getBucketName(), fileURI, Integer.valueOf(expiresIn * 3600));
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidExpiresRangeException | InvalidResponseException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            logger.error("get file url with qurey paramter fail", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OutputStream get(String bucketName, String objectName) {
        OutputStream outputStream2 = null;
        try (InputStream inputStream = this.minioClient.getObject(bucketName, objectName);){
            IoUtil.copy((InputStream)inputStream, outputStream2);
            OutputStream outputStream = outputStream2;
            return outputStream;
        }
        catch (Exception e) {
            logger.error("get object fail", (Throwable)e);
            return null;
        }
    }

    private void makeBucket(String bucketName) throws Exception {
        boolean isExist = this.minioClient.bucketExists(bucketName);
        if (!isExist) {
            this.minioClient.makeBucket(bucketName);
        }
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    @Override
    public String put(String group, String key, byte[] bytes) {
        return this.put(group, key, new ByteArrayInputStream(bytes));
    }

    @Override
    public Map<String, String> createSts(OssRegistryVo registryVo, TempSignCreateParam tempSignCreateParam) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }
}

