/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider.amazonaws.auth;

import com.dtyunxi.huieryun.oss.provider.amazonaws.auth.AWS4SignerBase;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.SimpleTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWS4SignerForAuthorizationHeader
extends AWS4SignerBase {
    private static final Logger logger = LoggerFactory.getLogger(AWS4SignerForAuthorizationHeader.class);
    private static final String BACKSLASH = "/";

    public AWS4SignerForAuthorizationHeader(URL endpointUrl, String httpMethod, String serviceName, String regionName) {
        super(endpointUrl, httpMethod, serviceName, regionName);
        this.dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        this.dateStampFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
    }

    public String computeSignature(Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey) {
        Date now = new Date();
        String dateTimeStamp = this.dateTimeFormat.format(now);
        headers.put("x-amz-date", dateTimeStamp);
        String hostHeader = this.endpointUrl.getHost();
        int port = this.endpointUrl.getPort();
        if (port > -1) {
            hostHeader.concat(":" + Integer.toString(port));
        }
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = AWS4SignerForAuthorizationHeader.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AWS4SignerForAuthorizationHeader.getCanonicalizedHeaderString(headers);
        String canonicalizedQueryParameters = AWS4SignerForAuthorizationHeader.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = AWS4SignerForAuthorizationHeader.getCanonicalRequest(this.endpointUrl, this.httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        logger.debug("--------- Canonical request --------");
        logger.debug(canonicalRequest);
        logger.debug("------------------------------------");
        String dateStamp = this.dateStampFormat.format(now);
        String scope = dateStamp + BACKSLASH + this.regionName + BACKSLASH + this.serviceName + BACKSLASH + "aws4_request";
        String stringToSign = AWS4SignerForAuthorizationHeader.getStringToSign("AWS4", "HMAC-SHA256", dateTimeStamp, scope, canonicalRequest);
        logger.debug("--------- String to sign -----------");
        logger.debug(stringToSign);
        logger.debug("------------------------------------");
        String signature = this.getHmacSHA256Signature(awsSecretKey, dateStamp, stringToSign);
        String credentialsAuthorizationHeader = "Credential=" + awsAccessKey + BACKSLASH + scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + signature;
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        return authorizationHeader;
    }
}

