/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider.amazonaws.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static String invokeHttpRequest(URL endpointUrl, String httpMethod, Map<String, String> headers, byte[] requestBody) {
        HttpURLConnection connection = HttpUtils.createHttpConnection(endpointUrl, httpMethod, headers);
        try {
            if (requestBody != null) {
                DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                wr.write(requestBody);
                wr.flush();
                wr.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Request failed. " + e.getMessage(), e);
        }
        return HttpUtils.executeHttpRequest(connection);
    }

    public static String executeHttpRequest(HttpURLConnection connection) {
        try {
            String line;
            InputStream is;
            try {
                is = connection.getInputStream();
            }
            catch (IOException e) {
                is = connection.getErrorStream();
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuffer response = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Request failed. " + e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static HttpURLConnection createHttpConnection(URL endpointUrl, String httpMethod, Map<String, String> headers) {
        try {
            HttpURLConnection connection = (HttpURLConnection)endpointUrl.openConnection();
            connection.setRequestMethod(httpMethod);
            if (headers != null) {
                logger.debug("--------- Request headers ---------");
                for (String headerKey : headers.keySet()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(headerKey + ": " + headers.get(headerKey));
                    }
                    connection.setRequestProperty(headerKey, headers.get(headerKey));
                }
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            return connection;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create connection. " + e.getMessage(), e);
        }
    }

    public static String urlEncode(String url, boolean keepPathSlash) {
        String encoded;
        try {
            encoded = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported.", e);
        }
        if (keepPathSlash) {
            encoded = encoded.replace("%2F", "/");
        }
        return encoded;
    }
}

