/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.autoconfigure;

import com.dtyunxi.huieryun.oss.autoconfigure.OssProperties;
import com.dtyunxi.huieryun.oss.constant.OssConstant;
import com.dtyunxi.huieryun.oss.enums.ObjectStorageType;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.util.SpringBeanUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.annotation.DependsOn;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

@DependsOn(value={"springBeanUtil"})
public class OssTypeSwitchInterceptor
implements WebRequestInterceptor {
    public void preHandle(WebRequest request) throws Exception {
        String ossType = request.getHeader("ossType");
        if (ossType == null) {
            return;
        }
        ObjectStorageType type = ObjectStorageType.valueOf((String)ossType.toUpperCase());
        OssRegistryVo registryVo = null;
        switch (type) {
            case AMAZONS3: {
                try {
                    registryVo = (OssRegistryVo)SpringBeanUtil.getBean((String)"awsOssProperties", OssRegistryVo.class);
                }
                catch (BeansException beansException) {}
                break;
            }
            case MINIO: {
                try {
                    registryVo = (OssRegistryVo)SpringBeanUtil.getBean((String)"minioOssProperties", OssRegistryVo.class);
                }
                catch (BeansException beansException) {}
                break;
            }
            case HUAWEIOBS: {
                try {
                    registryVo = (OssRegistryVo)SpringBeanUtil.getBean((String)"huaweiOssProperties", OssRegistryVo.class);
                }
                catch (BeansException beansException) {}
                break;
            }
            case JDCLOUDS3: {
                try {
                    registryVo = (OssRegistryVo)SpringBeanUtil.getBean((String)"jdCloudOssProperties", OssRegistryVo.class);
                }
                catch (BeansException beansException) {}
                break;
            }
            default: {
                try {
                    registryVo = (OssRegistryVo)SpringBeanUtil.getBean(OssProperties.class);
                    break;
                }
                catch (BeansException beansException) {
                    // empty catch block
                }
            }
        }
        if (registryVo == null) {
            return;
        }
        if (registryVo.equals(OssConstant.registryVo)) {
            return;
        }
        OssConstant.registryVo = registryVo;
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
    }
}

