/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.api;

import com.dtyunxi.huieryun.opensearch.api.AbstractIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.api.AbstractOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.AbstractSearchIndexService;
import com.dtyunxi.huieryun.opensearch.api.IIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.api.IIndicesMappingCacheService;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.enums.SearchProviderType;
import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchFactory {
    private static final Logger logger = LoggerFactory.getLogger(OpenSearchFactory.class);

    public static IOpenSearchService createOpenSearch(OpenSearchVo openSearchVo, IIndicesMappingCacheService indicesMappingCacheService) {
        if (openSearchVo == null) {
            throw new RuntimeException("OpenSearchFactory createOpenSearch failure , OpenSearchVo must is not null!");
        }
        String[] addresses = openSearchVo.getAddresses();
        if (addresses == null || addresses.length == 0) {
            throw new IllegalArgumentException("\u641c\u7d22\u670d\u52a1\u5668\u5730\u5740\u5c1a\u672a\u6307\u5b9a");
        }
        SearchProviderType provider = SearchProviderType.valueOf(openSearchVo.getType().toUpperCase());
        if (null == provider) {
            throw new IllegalArgumentException("\u672a\u6307\u5b9a\u641c\u7d22\u5ba2\u6237\u7aef\u7c7b\u578b");
        }
        AbstractOpenSearchService openSearchService = null;
        switch (provider) {
            case ES: {
                openSearchService = OpenSearchFactory.initializeService(AbstractOpenSearchService.class, "com.dtyunxi.huieryun.opensearch.provider.es5.ElasticSearchService");
                break;
            }
            case ES6: {
                openSearchService = OpenSearchFactory.initializeService(AbstractOpenSearchService.class, "com.dtyunxi.huieryun.opensearch.provider.es6.RestSearchService");
                break;
            }
            case ES6_5: {
                openSearchService = OpenSearchFactory.initializeService(AbstractOpenSearchService.class, "com.dtyunxi.huieryun.opensearch.provider.es65.RestSearchService");
                break;
            }
            case ES6_8: {
                openSearchService = OpenSearchFactory.initializeService(AbstractOpenSearchService.class, "com.dtyunxi.huieryun.opensearch.provider.es68.RestSearchService");
                break;
            }
            case ES7_1: {
                openSearchService = OpenSearchFactory.initializeService(AbstractOpenSearchService.class, "com.dtyunxi.huieryun.opensearch.provider.es71.RestSearchService");
                break;
            }
            case ES7_4: {
                openSearchService = OpenSearchFactory.initializeService(AbstractOpenSearchService.class, "com.dtyunxi.huieryun.opensearch.provider.es74.RestSearchService");
            }
        }
        if (null == openSearchService) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u6307\u5b9a\u641c\u7d22\u5ba2\u6237\u7aef\u7c7b\u578b\u7684\u5b9e\u73b0\u7c7b");
        }
        openSearchService.init(openSearchVo);
        openSearchService.setIndicesMappingCacheService(indicesMappingCacheService);
        return openSearchService;
    }

    public static ISearchIndexService createSearchIndexService(OpenSearchVo openSearchVo) {
        if (openSearchVo == null) {
            throw new RuntimeException("OpenSearchFactory createSearchIndexService failure , OpenSearchVo must is not null!");
        }
        logger.debug("OpenSearchFactory createSearchIndexService init ... ");
        SearchProviderType provider = SearchProviderType.valueOf(openSearchVo.getType().toUpperCase());
        if (null == provider) {
            throw new IllegalArgumentException("\u672a\u6307\u5b9a\u641c\u7d22\u5ba2\u6237\u7aef\u7c7b\u578b");
        }
        AbstractSearchIndexService searchIndexService = null;
        switch (provider) {
            case ES: {
                searchIndexService = OpenSearchFactory.initializeService(AbstractSearchIndexService.class, "com.dtyunxi.huieryun.opensearch.provider.es5.ElasticSearchIndexService");
                break;
            }
            case ES6: {
                searchIndexService = OpenSearchFactory.initializeService(AbstractSearchIndexService.class, "com.dtyunxi.huieryun.opensearch.provider.es6.RestIndexService");
                break;
            }
            case ES6_5: {
                searchIndexService = OpenSearchFactory.initializeService(AbstractSearchIndexService.class, "com.dtyunxi.huieryun.opensearch.provider.es65.RestIndexService");
                break;
            }
            case ES6_8: {
                searchIndexService = OpenSearchFactory.initializeService(AbstractSearchIndexService.class, "com.dtyunxi.huieryun.opensearch.provider.es68.RestIndexService");
                break;
            }
            case ES7_1: {
                searchIndexService = OpenSearchFactory.initializeService(AbstractSearchIndexService.class, "com.dtyunxi.huieryun.opensearch.provider.es71.RestIndexService");
                break;
            }
            case ES7_4: {
                searchIndexService = OpenSearchFactory.initializeService(AbstractSearchIndexService.class, "com.dtyunxi.huieryun.opensearch.provider.es74.RestIndexService");
            }
        }
        if (null == searchIndexService) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u6307\u5b9a\u641c\u7d22\u5ba2\u6237\u7aef\u7c7b\u578b\u7684\u5b9e\u73b0\u7c7b");
        }
        searchIndexService.init(openSearchVo);
        return searchIndexService;
    }

    public static IIndicesAdminService createIndicesAdminService(OpenSearchVo openSearchVo, IIndicesMappingCacheService indicesMappingCacheService) {
        if (openSearchVo == null) {
            throw new RuntimeException("OpenSearchFactory createIndicesAdminService failure , OpenSearchVo must is not null!");
        }
        logger.debug("OpenSearchFactory createIndicesAdminService");
        SearchProviderType provider = SearchProviderType.valueOf(openSearchVo.getType().toUpperCase());
        AbstractIndicesAdminService indicesAdminService = null;
        if (null == provider) {
            throw new IllegalArgumentException("\u672a\u6307\u5b9a\u641c\u7d22\u5ba2\u6237\u7aef\u7c7b\u578b");
        }
        switch (provider) {
            case ES: {
                indicesAdminService = OpenSearchFactory.initializeService(AbstractIndicesAdminService.class, "com.dtyunxi.huieryun.opensearch.provider.es5.ElasticSearchIndicesAdminService");
                break;
            }
            case ES6: {
                indicesAdminService = OpenSearchFactory.initializeService(AbstractIndicesAdminService.class, "com.dtyunxi.huieryun.opensearch.provider.es6.RestIndicesAdminService");
                break;
            }
            case ES6_5: {
                indicesAdminService = OpenSearchFactory.initializeService(AbstractIndicesAdminService.class, "com.dtyunxi.huieryun.opensearch.provider.es65.RestIndicesAdminService");
                break;
            }
            case ES6_8: {
                indicesAdminService = OpenSearchFactory.initializeService(AbstractIndicesAdminService.class, "com.dtyunxi.huieryun.opensearch.provider.es68.RestIndicesAdminService");
                break;
            }
            case ES7_1: {
                indicesAdminService = OpenSearchFactory.initializeService(AbstractIndicesAdminService.class, "com.dtyunxi.huieryun.opensearch.provider.es71.RestIndicesAdminService");
                break;
            }
            case ES7_4: {
                indicesAdminService = OpenSearchFactory.initializeService(AbstractIndicesAdminService.class, "com.dtyunxi.huieryun.opensearch.provider.es74.RestIndicesAdminService");
            }
        }
        if (null == indicesAdminService) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u6307\u5b9a\u641c\u7d22\u5ba2\u6237\u7aef\u7c7b\u578b\u7684\u5b9e\u73b0\u7c7b");
        }
        indicesAdminService.init(openSearchVo);
        indicesAdminService.setIndicesMappingCacheService(indicesMappingCacheService);
        return indicesAdminService;
    }

    private static <T> T initializeService(Class<T> clazz, String className) {
        try {
            clazz = Class.forName(className, true, OpenSearchFactory.class.getClassLoader());
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("{}\u7c7b\u672a\u627e\u5230\uff01", (Object)className, (Object)e);
            throw new RuntimeException(className + "\u7c7b\u672a\u627e\u5230\uff01");
        }
    }
}

