/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.utils;

import java.util.regex.Pattern;

public class CharUtil {
    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!CharUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChineseByREG(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FBF]+");
        return pattern.matcher(str.trim()).find();
    }

    public static boolean isChineseByName(String str) {
        if (str == null) {
            return false;
        }
        String reg = "\\p{InCJK Unified Ideographs}&amp;&amp;\\P{Cn}";
        Pattern pattern = Pattern.compile(reg);
        return pattern.matcher(str.trim()).find();
    }

    public static boolean isEnglish(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    public static boolean isEnglishWord(String strName) {
        if (strName == null) {
            return false;
        }
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (CharUtil.isEnglish(c)) continue;
            return false;
        }
        return true;
    }
}

