/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.lock.provider.redis;

import com.dtyunxi.huieryun.lock.api.AbstractLockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.registry.vo.LockRegistryVo;
import com.dtyunxi.huieryun.registry.vo.WorkModel;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.ClusterServersConfig;
import org.redisson.Config;
import org.redisson.MasterSlaveServersConfig;
import org.redisson.Redisson;
import org.redisson.RedissonClient;
import org.redisson.SentinelServersConfig;
import org.redisson.SingleServerConfig;
import org.redisson.core.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLockService
extends AbstractLockService {
    private static final Logger logger = LoggerFactory.getLogger(RedisLockService.class);
    private RedissonClient redisson;
    private static final int MAX_WAIT_TIMEOUT = 3;
    private static final int MAX_KEEP_TIMEOUT = 60;

    public void init(LockRegistryVo lockVo) {
        super.init(lockVo);
        Config config = new Config();
        if (WorkModel.SINGLE.getName().equals(lockVo.getWorkModel())) {
            SingleServerConfig singleSerververConfig = config.useSingleServer();
            singleSerververConfig.setAddress(lockVo.getEndpoints()[0]);
            if (StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) {
                singleSerververConfig.setPassword(lockVo.getPasswd());
            }
        } else if (WorkModel.SENTINE.getName().equals(lockVo.getWorkModel())) {
            SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
            sentinelServersConfig.addSentinelAddress(lockVo.getEndpoints());
            if (StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) {
                sentinelServersConfig.setPassword(lockVo.getPasswd());
            }
        } else if (WorkModel.CLUSTER.getName().equals(lockVo.getWorkModel())) {
            ClusterServersConfig clusterServersConfig = config.useClusterServers();
            clusterServersConfig.addNodeAddress(lockVo.getEndpoints());
            if (StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) {
                clusterServersConfig.setPassword(lockVo.getPasswd());
            }
        } else if (WorkModel.MASTERSLAVE.getName().equals(lockVo.getWorkModel())) {
            MasterSlaveServersConfig masterSlaveServersConfig = config.useMasterSlaveServers();
            String master = lockVo.getEndpoints()[0];
            masterSlaveServersConfig.setMasterAddress(master);
            if (lockVo.getEndpoints().length > 1) {
                String[] slaves = Arrays.copyOfRange(lockVo.getEndpoints(), 1, lockVo.getEndpoints().length);
                masterSlaveServersConfig.addSlaveAddress(slaves);
            }
            if (StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) {
                masterSlaveServersConfig.setPassword(lockVo.getPasswd());
            }
        }
        this.redisson = Redisson.create((Config)config);
    }

    public Mutex lock(String tableName, Long primaryKey) {
        return this.lock(tableName, String.valueOf(primaryKey), 3);
    }

    public Mutex lock(String tableName, String primaryKey) {
        return this.lock(tableName, primaryKey, 3);
    }

    public Mutex lock(String tableName, Long primaryKey, int waitTimeout) {
        return this.lock(tableName, String.valueOf(primaryKey), waitTimeout);
    }

    public Mutex lock(String tableName, String primaryKey, int waitTimeout) {
        return this.lock(tableName, primaryKey, waitTimeout, 60, TimeUnit.SECONDS);
    }

    public Mutex lock(String tableName, String primaryKey, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        Mutex mutex = new Mutex(lockKey);
        RLock rLock = this.redisson.getLock(lockKey);
        try {
            boolean res = rLock.tryLock((long)waitTimeout, (long)leaseTime, timeUnit);
            if (!res) {
                throw new BusinessRuntimeException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return mutex;
    }

    public boolean unlock(Mutex mutex) {
        if (null == mutex) {
            return true;
        }
        try {
            RLock rLock = this.redisson.getLock(mutex.getLockKey());
            rLock.unlock();
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isLocked(String tableName, Long primaryKey) {
        return this.isLocked(tableName, String.valueOf(primaryKey));
    }

    public boolean isLocked(String tableName, String primaryKey) {
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        RLock rLock = this.redisson.getLock(lockKey);
        return rLock.isLocked();
    }

    public String getLockAcquirer(String tableName, Long primaryKey) {
        return null;
    }

    public String getLockAcquirer(String tableName, String primaryKey) {
        return null;
    }
}

