/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchapi.es;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESClient {
    private static final Logger logger = LoggerFactory.getLogger(ESClient.class);
    private String cluster;
    private String appKey;
    private String appSecret;
    private String host;
    private Integer port;
    private Boolean sniff;

    public ESClient(String cluster, String appKey, String appSecret, String host, Integer port, Boolean sniff) {
        this.cluster = cluster;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.host = host;
        this.port = port;
        this.sniff = sniff;
    }

    public TransportClient getClient() throws UnknownHostException {
        TransportClient transportClient = null;
        Settings.Builder builder = Settings.builder();
        if (this.sniff != null) {
            builder.put("client.transport.sniff", this.sniff.booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.cluster)) {
            builder.put("cluster.name", this.cluster);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.appKey) && StringUtils.isNotEmpty((CharSequence)this.appSecret)) {
            builder.put("xpack.security.user", this.appKey + ":" + this.appSecret);
        }
        try {
            transportClient = new PreBuiltXPackTransportClient(builder.build(), new Class[0]).addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(this.host), this.port.intValue()));
            return transportClient;
        }
        catch (Exception e) {
            logger.error("ElasticSearchService init failure!", (Throwable)e);
            throw new RuntimeException("ElasticSearchService init", e);
        }
    }
}

