/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchapi.es;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.huieryun.searchapi.es.ESClient;
import com.dtyunxi.huieryun.searchapi.es.ESOperations;
import com.dtyunxi.huieryun.searchapi.es.RowMapper;
import com.dtyunxi.huieryun.searchapi.es.vo.Sort;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;

public class ESTemplate
implements ESOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(ESTemplate.class);
    private TransportClient client;
    private Long totalSize;

    public ESTemplate(ESClient esClient) throws UnknownHostException {
        this.client = esClient.getClient();
    }

    @Override
    public TransportClient getClient() {
        return this.client;
    }

    public <T> List<T> query(String index, String type, RowMapper<T> mapper, Integer pageNum, Integer pageSize) {
        LOGGER.debug("Enter into query method. index={}, type={}", (Object)index, (Object)type);
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.QUERY_THEN_FETCH);
        LOGGER.info("searchRequestBuilder={}", (Object)searchRequestBuilder);
        SearchResponse searchResponse = null;
        searchResponse = pageNum != null && pageSize != null ? (SearchResponse)searchRequestBuilder.setFrom((pageNum - 1) * pageSize).setSize(pageSize.intValue()).get() : (SearchResponse)searchRequestBuilder.get();
        LOGGER.debug("searchResponse={}", (Object)searchResponse);
        SearchHit[] hits = searchResponse.getHits().getHits();
        this.setTotalSize(searchResponse);
        ArrayList<T> rs = new ArrayList<T>();
        for (SearchHit searchHit : hits) {
            rs.add(mapper.mapRow(searchHit));
        }
        return rs;
    }

    @Override
    public <T> List<T> queryWithFilter(String index, String type, QueryBuilder queryBuilder, RowMapper<T> mapper) {
        LOGGER.debug("Enter into queryWithFilter method. index={}, type={}", (Object)index, (Object)type);
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.QUERY_THEN_FETCH);
        searchRequestBuilder.setQuery(queryBuilder);
        LOGGER.info("searchRequestBuilder={}", (Object)searchRequestBuilder);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        LOGGER.debug("searchResponse={}", (Object)searchResponse);
        SearchHit[] hits = searchResponse.getHits().getHits();
        this.setTotalSize(searchResponse);
        ArrayList<T> rs = new ArrayList<T>();
        for (SearchHit searchHit : hits) {
            rs.add(mapper.mapRow(searchHit));
        }
        return rs;
    }

    @Override
    public <T> List<T> queryWithFilter(String index, String type, QueryBuilder queryBuilder, Integer pageNum, Integer pageSize, RowMapper<T> mapper) {
        LOGGER.debug("Enter into queryWithFilter method. index={}, type={}, pageNum={}, pageSize={}", new Object[]{index, type, pageNum, pageSize});
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.QUERY_THEN_FETCH);
        searchRequestBuilder.setQuery(queryBuilder);
        LOGGER.info("searchRequestBuilder={}", (Object)searchRequestBuilder);
        SearchResponse searchResponse = null;
        searchResponse = pageNum != null && pageSize != null ? (SearchResponse)searchRequestBuilder.setFrom((pageNum - 1) * pageSize).setSize(pageSize.intValue()).get() : (SearchResponse)searchRequestBuilder.get();
        LOGGER.debug("searchResponse={}", (Object)searchResponse);
        SearchHit[] hits = searchResponse.getHits().getHits();
        this.setTotalSize(searchResponse);
        ArrayList<T> rs = new ArrayList<T>();
        for (SearchHit searchHit : hits) {
            rs.add(mapper.mapRow(searchHit));
        }
        return rs;
    }

    public SearchHit[] queryWithFilter(String index, String type, QueryBuilder queryBuilder) {
        LOGGER.debug("Enter into queryWithFilter method. index={}, type={}", (Object)index, (Object)type);
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.QUERY_THEN_FETCH);
        searchRequestBuilder.setQuery(queryBuilder);
        LOGGER.info("searchRequestBuilder={}", (Object)searchRequestBuilder);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        LOGGER.debug("searchResponse={}", (Object)searchResponse);
        return searchResponse.getHits().getHits();
    }

    public <T> List<T> pagingAndSortQuery(String index, String type, QueryBuilder queryBuilder, String sortField, String sortType, Integer pageNum, Integer pageSize, RowMapper<T> mapper) {
        LOGGER.debug("Enter into pagingAndSortQuery method. index={}, type={}, sortField={}, sortType={}, pageNum={}, pageSize={}", new Object[]{index, type, sortField, sortType, pageNum, pageSize});
        SearchRequestBuilder searchRequestBuilder = null;
        searchRequestBuilder = sortType.equals("ASC") || sortType.equals("asc") ? this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.QUERY_THEN_FETCH).addSort(sortField, SortOrder.ASC) : this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.QUERY_THEN_FETCH).addSort(sortField, SortOrder.DESC);
        if (queryBuilder != null) {
            searchRequestBuilder.setQuery(queryBuilder);
        }
        LOGGER.info("searchRequestBuilder={}", (Object)searchRequestBuilder);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.setFrom((pageNum - 1) * pageSize).setSize(pageSize.intValue()).get();
        LOGGER.debug("searchResponse={}", (Object)searchResponse);
        SearchHit[] hits = searchResponse.getHits().getHits();
        this.setTotalSize(searchResponse);
        ArrayList<T> rs = new ArrayList<T>();
        for (SearchHit searchHit : hits) {
            rs.add(mapper.mapRow(searchHit));
        }
        return rs;
    }

    public <T> List<T> pagingAndSortQuery(String index, String type, QueryBuilder queryBuilder, List<Sort> sortList, Integer pageNum, Integer pageSize, RowMapper<T> mapper) {
        LOGGER.debug("Enter into pagingAndSortQuery method. index={}, type={}, sortList={}, pageNum={}, pageSize={}", new Object[]{index, type, sortList, pageNum, pageSize});
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.QUERY_THEN_FETCH);
        if (sortList != null && !sortList.isEmpty()) {
            for (Sort each : sortList) {
                each.getFiled();
                each.getSortOrder();
                searchRequestBuilder.addSort(each.getFiled(), each.getSortOrder());
            }
        }
        if (queryBuilder != null) {
            searchRequestBuilder.setQuery(queryBuilder);
        }
        LOGGER.info("searchRequestBuilder={}", (Object)searchRequestBuilder);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.setFrom((pageNum - 1) * pageSize).setSize(pageSize.intValue()).get();
        LOGGER.debug("searchResponse={}", (Object)searchResponse);
        SearchHit[] hits = searchResponse.getHits().getHits();
        this.setTotalSize(searchResponse);
        ArrayList<T> rs = new ArrayList<T>();
        for (SearchHit searchHit : hits) {
            rs.add(mapper.mapRow(searchHit));
        }
        return rs;
    }

    public SearchHit[] queryWithFilter(String index, String type, QueryBuilder queryBuilder, Integer pageNum, Integer pageSize) {
        LOGGER.debug("Enter into queryWithFilter method. index={}, type={}", (Object)index, (Object)type);
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.QUERY_THEN_FETCH);
        searchRequestBuilder.setQuery(queryBuilder);
        searchRequestBuilder.setFrom(pageNum - 1);
        searchRequestBuilder.setSize(pageSize.intValue());
        LOGGER.info("searchRequestBuilder={}", (Object)searchRequestBuilder);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        LOGGER.debug("searchResponse={}", (Object)searchResponse);
        return searchResponse.getHits().getHits();
    }

    public IndexResponse indexDoc(String index, String type, String docId, Map<String, Object> source) {
        return (IndexResponse)this.client.prepareIndex(index, type, docId).setRouting(docId).setSource(source).get();
    }

    public IndexResponse indexDocWithRouting(String index, String type, String docId, String parentId, Map<String, Object> source) {
        return (IndexResponse)this.client.prepareIndex(index, type, docId).setParent(parentId).setRouting(parentId).setSource(source).get();
    }

    public UpdateResponse updateDoc(String index, String type, String docId, Map<String, Object> source) throws InterruptedException, ExecutionException {
        UpdateRequest updateRequest = new UpdateRequest(index, type, docId);
        updateRequest.doc(source);
        return (UpdateResponse)this.client.update(updateRequest).get();
    }

    public UpdateResponse updateDocWithRouting(String index, String type, String docId, String parentId, Map<String, Object> source) throws InterruptedException, ExecutionException {
        UpdateRequest updateRequest = new UpdateRequest(index, type, docId);
        updateRequest.parent(parentId);
        updateRequest.routing(parentId);
        updateRequest.doc(source);
        return (UpdateResponse)this.client.update(updateRequest).get();
    }

    public DeleteResponse deleteDoc(String index, String type, String docId) {
        return (DeleteResponse)this.client.prepareDelete(index, type, docId).get();
    }

    public DeleteResponse deleteDoc(String index, String type, String docId, String parentId) {
        return (DeleteResponse)this.client.prepareDelete(index, type, docId).setRouting(parentId).get();
    }

    public CreateIndexResponse createIndex(String index) {
        return (CreateIndexResponse)this.client.admin().indices().prepareCreate(index).get();
    }

    public PutMappingResponse createIndexMapping(String index, String type, String json) {
        return (PutMappingResponse)this.client.admin().indices().preparePutMapping(new String[]{index}).setType(type).setSource(json, XContentType.JSON).get();
    }

    public PutMappingResponse createIndexMapping(String index, String json) {
        return (PutMappingResponse)this.client.admin().indices().preparePutMapping(new String[]{index}).setSource(json, XContentType.JSON).get();
    }

    public boolean isExistsIndex(String indexName) {
        IndicesExistsResponse response = (IndicesExistsResponse)this.getClient().admin().indices().exists(new IndicesExistsRequest().indices(new String[]{indexName})).actionGet();
        return response.isExists();
    }

    public boolean isExistsType(String indexName, String indexType) {
        TypesExistsResponse response = (TypesExistsResponse)this.getClient().admin().indices().typesExists(new TypesExistsRequest(new String[]{indexName}, new String[]{indexType})).actionGet();
        return response.isExists();
    }

    public void setTotalSize(SearchResponse response) {
        this.totalSize = response.getHits().getTotalHits();
    }

    public void updateIndex(String index, String type, String docId, Map<String, Object> source) {
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.index(index);
        updateRequest.type(type);
        updateRequest.id(docId);
        updateRequest.doc(source);
        try {
            this.client.update(updateRequest).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("updateIndex failure!", (Throwable)e);
        }
    }

    public void updateIndex(String index, String type, String docId, Script script) {
        UpdateRequest updateRequest = new UpdateRequest(index, type, docId).script(script);
        try {
            this.client.update(updateRequest).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("updateIndex failure!", (Throwable)e);
        }
    }

    public Long count(String index, String type, QueryBuilder queryBuilder) {
        return ((SearchResponse)this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSize(0).setQuery(queryBuilder).get()).getHits().getTotalHits();
    }

    public Aggregations aggregate(String index, String type, QueryBuilder queryBuilder, AggregationBuilder aggregationBuilder) {
        LOGGER.debug("Enter into pagingAndSortQuery method. index={}, type={}, queryBuilder={}, aggregationBuilder={}", new Object[]{index, type, JSON.toJSONString((Object)queryBuilder), JSON.toJSONString((Object)aggregationBuilder)});
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.QUERY_THEN_FETCH);
        if (queryBuilder != null) {
            searchRequestBuilder.setQuery(queryBuilder);
        }
        if (aggregationBuilder != null) {
            searchRequestBuilder.addAggregation(aggregationBuilder);
        }
        searchRequestBuilder.setSize(0);
        searchRequestBuilder.setFetchSource(false);
        LOGGER.debug("searchRequestBuilder={}", (Object)searchRequestBuilder);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        LOGGER.debug("searchResponse={}", (Object)searchResponse);
        return searchResponse.getAggregations();
    }

    public void bulkIndex(BulkRequestBuilder bulkRequestBuilder) {
        BulkResponse bulkResponse = (BulkResponse)bulkRequestBuilder.get();
        if (bulkResponse.hasFailures()) {
            LOGGER.error("\u6279\u91cf\u63d2\u5165\u6709\u8aa4\uff01");
        }
    }

    public Long getTotalSize() {
        return this.totalSize;
    }

    public void setClient(TransportClient client) {
        this.client = client;
    }
}

