/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.starter.localcache;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.starter.localcache.CacheReturnTypeSourceAdvisor;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheManager;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheRegistryProperties;
import com.dtyunxi.util.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;

@EnableCaching
@EnableConfigurationProperties(value={LocalCacheRegistryProperties.class})
public class LocalCacheAutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(LocalCacheAutoConfiguration.class);
    private final LocalCacheRegistryProperties properties;
    private final ICacheService cacheService;

    public LocalCacheAutoConfiguration(LocalCacheRegistryProperties properties, ObjectProvider<ICacheService> cacheService) throws IllegalAccessException {
        if (log.isDebugEnabled()) {
            log.debug(JacksonUtil.toJson((Object)properties));
        }
        this.properties = properties;
        this.cacheService = (ICacheService)cacheService.getIfAvailable();
        if (properties.isRemoteCache() && this.cacheService == null) {
            throw new IllegalAccessException("\u8fdc\u7a0b\u7f13\u5b58\u5c1a\u672a\u914d\u7f6e");
        }
    }

    @Bean
    public LocalCacheManager cacheManager() {
        return new LocalCacheManager(this.properties, this.cacheService);
    }

    @Bean
    @ConditionalOnProperty(prefix="huieryun.localcacheregistryvo", name={"remoteCache"}, havingValue="true")
    @Role(value=2)
    public CacheReturnTypeSourceAdvisor returnTypeSourceAdvisor(CacheManager cacheManager) {
        return new CacheReturnTypeSourceAdvisor(cacheManager);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.properties == null) {
            log.error("localcacheregistryvo \u5c1a\u672a\u914d\u7f6e");
            return;
        }
        if (this.properties.getLocalCache() == null) {
            log.warn("localcacheregistryvo \u672c\u5730\u7f13\u5b58\u5c1a\u672a\u914d\u7f6e");
        }
        if (this.cacheService == null) {
            log.warn("localcacheregistryvo \u8fdc\u7a0b\u7f13\u5b58\u5c1a\u672a\u914d\u7f6e");
        }
        log.info("LocalCacheAutoConfiguration \u5df2\u88c5\u8f7d");
    }
}

